/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.adobe.acs.commons.reports.internal.DelimiterConfiguration;
import com.adobe.granite.references.Reference;
import com.adobe.granite.references.ReferenceAggregator;
import com.adobe.granite.references.ReferenceList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class ReferencesModel
implements ReportCellCSVExporter {
    private static final Logger log = LoggerFactory.getLogger(ReferencesModel.class);
    @ValueMapValue
    @OSGiService
    private ReferenceAggregator aggregator;
    @OSGiService
    private DelimiterConfiguration delimiterConfiguration;
    private ReferenceList referenceList;
    private Resource resource;

    public ReferencesModel(Resource resource) {
        this.resource = resource;
    }

    ReferencesModel(Resource resource, DelimiterConfiguration delimiterConfiguration) {
        this.resource = resource;
        this.delimiterConfiguration = delimiterConfiguration;
    }

    public List<Reference> getReferences() {
        return Optional.ofNullable(this.referenceList).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    @Override
    public String getValue(Object result) {
        this.resource = (Resource)result;
        this.init();
        ArrayList<String> refStrings = new ArrayList<String>();
        for (Reference reference : this.referenceList) {
            refStrings.add(reference.getType() + " - " + reference.getTarget().getPath());
        }
        return StringUtils.join(refStrings, (String)this.delimiterConfiguration.getMultiValueDelimiter());
    }

    @PostConstruct
    public void init() {
        if (this.resource == null) {
            throw new IllegalStateException("Resource is null, and must must be set before calling init()");
        }
        this.referenceList = this.aggregator.createReferenceList(this.resource);
        Iterator references = this.referenceList.iterator();
        while (references.hasNext()) {
            Reference reference = (Reference)references.next();
            if (reference == null) {
                log.warn("Reference is null for resource: {}", (Object)this.resource.getPath());
                continue;
            }
            Resource target = reference.getTarget();
            if (target == null) {
                log.warn("Reference target is null for resource: {}", (Object)this.resource.getPath());
                continue;
            }
            String targetPath = target.getPath();
            if (StringUtils.isBlank((CharSequence)targetPath)) {
                log.warn("Reference target path is blank for resource: {}", (Object)this.resource.getPath());
                continue;
            }
            if (!StringUtils.equals((CharSequence)targetPath, (CharSequence)this.resource.getPath())) continue;
            references.remove();
        }
    }
}

