/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.internal.datasources;

import com.adobe.acs.commons.util.QueryHelper;
import com.adobe.acs.commons.wcm.datasources.DataSourceBuilder;
import com.adobe.acs.commons.wcm.datasources.DataSourceOption;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=acs-commons/components/utilities/report-builder/data-sources/dynamic-select", "sling.servlet.methods=GET"})
public class DynamicSelectDataSource
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -4060071633522289836L;
    private static final Logger log = LoggerFactory.getLogger(DynamicSelectDataSource.class);
    static final String PN_DROP_DOWN_QUERY_LANGUAGE = "dropDownQueryLanguage";
    static final String PN_DROP_DOWN_QUERY = "dropDownQuery";
    static final String PN_ALLOW_PROPERTY_NAMES = "allowedPropertyNames";
    @Reference
    private transient DataSourceBuilder dataSourceBuilder;
    @Reference
    private transient QueryHelper queryHelper;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resolver = request.getResourceResolver();
        ValueMap properties = request.getResource().getValueMap();
        ArrayList<DataSourceOption> options = new ArrayList<DataSourceOption>();
        try {
            String queryLanguage = (String)properties.get(PN_DROP_DOWN_QUERY_LANGUAGE, (Object)"JCR-SQL2");
            String queryStatement = (String)properties.get(PN_DROP_DOWN_QUERY, String.class);
            String[] allowedPropertyNames = (String[])properties.get(PN_ALLOW_PROPERTY_NAMES, (Object)new String[0]);
            if (StringUtils.isNotBlank((CharSequence)queryStatement)) {
                List<Resource> results = this.queryHelper.findResources(resolver, queryLanguage, queryStatement, "");
                ArrayList distinctOptionValues = new ArrayList();
                for (Resource resource : results) {
                    resource.getValueMap().entrySet().stream().filter(entry -> entry.getValue() instanceof String).filter(entry -> ArrayUtils.isEmpty((Object[])allowedPropertyNames) || ArrayUtils.contains((Object[])allowedPropertyNames, entry.getKey())).filter(entry -> !distinctOptionValues.contains(entry.getValue().toString())).forEach(entry -> {
                        String value = entry.getValue().toString();
                        distinctOptionValues.add(value);
                        options.add(new DataSourceOption(value, value));
                    });
                }
            }
            this.dataSourceBuilder.addDataSource(request, options);
        }
        catch (Exception e) {
            log.error("Unable to collect the information to populate the ACS Commons Report Builder dynamic-select drop-down.", (Throwable)e);
            response.sendError(500);
        }
    }
}

