/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DispatcherFlushFilter
implements AgentFilter {
    public static final DispatcherFlushFilter ALL = new DispatcherFlushFilter(FlushType.All);
    public static final DispatcherFlushFilter HIERARCHICAL = new DispatcherFlushFilter(FlushType.Hierarchical);
    public static final DispatcherFlushFilter RESOURCE_ONLY = new DispatcherFlushFilter(FlushType.ResourceOnly);
    private static final String SERIALIZATION_TYPE = "flush";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String CQ_ACTION_HEADER = "CQ-Action:";
    private static final String CQ_SCOPE_ACTION_HEADER = "CQ-Action-Scope: ResourceOnly";
    private final FlushType flushType;

    public DispatcherFlushFilter() {
        this.flushType = FlushType.All;
    }

    public DispatcherFlushFilter(FlushType flushType) {
        this.flushType = flushType;
    }

    public final boolean isIncluded(Agent agent) {
        if (FlushType.All.equals((Object)this.flushType)) {
            return this.isIncludedCommon(agent);
        }
        if (FlushType.Hierarchical.equals((Object)this.flushType)) {
            return this.isIncludedHierarchical(agent);
        }
        if (FlushType.ResourceOnly.equals((Object)this.flushType)) {
            return this.isIncludedResourceOnly(agent);
        }
        return false;
    }

    public final FlushType getFlushType() {
        return this.flushType;
    }

    private boolean isIncludedCommon(Agent agent) {
        return this.isFlushingAgent(agent) && this.isDispatcherTransportURI(agent) && this.isDispatcherHeaders(agent) && this.isEnabled(agent);
    }

    private boolean isIncludedHierarchical(Agent agent) {
        return this.isIncludedCommon(agent) && !this.isResourceOnly(agent);
    }

    private boolean isIncludedResourceOnly(Agent agent) {
        return this.isIncludedCommon(agent) && this.isResourceOnly(agent);
    }

    private boolean isEnabled(Agent agent) {
        return agent.isEnabled();
    }

    private boolean isFlushingAgent(Agent agent) {
        return StringUtils.startsWith((CharSequence)agent.getConfiguration().getSerializationType(), (CharSequence)SERIALIZATION_TYPE);
    }

    private boolean isDispatcherTransportURI(Agent agent) {
        String transportURI = agent.getConfiguration().getTransportURI();
        return StringUtils.startsWith((CharSequence)transportURI, (CharSequence)HTTP) || StringUtils.startsWith((CharSequence)transportURI, (CharSequence)HTTPS);
    }

    private boolean isDispatcherHeaders(Agent agent) {
        String[] headers;
        ValueMap properties = agent.getConfiguration().getProperties();
        for (String header : headers = (String[])properties.get("protocolHTTPHeaders", (Object)new String[0])) {
            if (!StringUtils.startsWith((CharSequence)header, (CharSequence)CQ_ACTION_HEADER)) continue;
            return true;
        }
        return false;
    }

    private boolean isResourceOnly(Agent agent) {
        String[] headers;
        ValueMap properties = agent.getConfiguration().getProperties();
        for (String header : headers = (String[])properties.get("protocolHTTPHeaders", (Object)new String[0])) {
            if (!StringUtils.equals((CharSequence)header, (CharSequence)CQ_SCOPE_ACTION_HEADER)) continue;
            return true;
        }
        return false;
    }

    public static enum FlushType {
        All,
        Hierarchical,
        ResourceOnly;

    }
}

