/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.TagProperty;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Injector.class}, property={"service.ranking:Integer=5520"})
public class TagPropertyInjector
implements Injector {
    private static final Logger logger = LoggerFactory.getLogger(TagPropertyInjector.class);

    @NotNull
    public String getName() {
        return "tag-property";
    }

    @Nullable
    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (element.isAnnotationPresent(TagProperty.class)) {
            String[] tagKeys;
            TagProperty annotation = element.getAnnotation(TagProperty.class);
            ResourceResolver resourceResolver = InjectorUtils.getResourceResolver(adaptable);
            if (resourceResolver == null) {
                logger.error("ResourceResolver is null, cannot inject tag property. Are you adapting from a resource or SlingHttpServletRequest?");
                return null;
            }
            TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
            if (tagManager == null) {
                logger.error("TagManager is null, cannot inject tag property. Are you adapting from a resource or SlingHttpServletRequest?");
                return null;
            }
            String key = (String)StringUtils.defaultIfEmpty((CharSequence)annotation.value(), (CharSequence)name);
            if (annotation.inherit()) {
                HierarchyNodeInheritanceValueMap inheritanceValueMap = new HierarchyNodeInheritanceValueMap(InjectorUtils.getResource(adaptable));
                tagKeys = (String[])inheritanceValueMap.getInherited(key, String[].class);
            } else {
                tagKeys = (String[])InjectorUtils.getResource(adaptable).getValueMap().get(key, String[].class);
            }
            if (tagKeys == null || tagKeys.length == 0) {
                return null;
            }
            Stream<Tag> tagStream = Arrays.stream(tagKeys).map(arg_0 -> ((TagManager)tagManager).resolve(arg_0));
            if (ReflectionUtil.isSetType(declaredType) && ReflectionUtil.getGenericParameter(declaredType).equals(Tag.class)) {
                return tagStream.collect(Collectors.toSet());
            }
            if ((ReflectionUtil.isListType(declaredType) || ReflectionUtil.isCollectionType(declaredType)) && ReflectionUtil.getGenericParameter(declaredType).equals(Tag.class)) {
                return tagStream.collect(Collectors.toList());
            }
            if (ReflectionUtil.isArray(declaredType) && ReflectionUtil.getClassOrGenericParam(declaredType).equals(Tag.class)) {
                return tagStream.toArray(Tag[]::new);
            }
            return tagStream.filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }
}

