/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class}, property={"process.label=Copy properties"})
public class CopyPropertiesProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CopyPropertiesProcess.class);
    private static final String PN_PROPERTY_MAP = "PROPERTY_MAP";
    private static final String SEPARATOR = "->";
    private static final String ALTERNATE_SEPARATOR = "=>";
    private static final String EVENT_DATA = "acs-aem-commons.workflow.copy-properties";
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private WorkflowHelper workflowHelper;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        String wfPayload = null;
        try (ResourceResolver resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);){
            wfPayload = (String)workItem.getWorkflowData().getPayload();
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, wfPayload);
            for (String payload : payloads) {
                this.copyProperties(metaDataMap, resourceResolver, payload);
            }
            if (resourceResolver.hasChanges()) {
                this.setJcrSessionUserData(resourceResolver);
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException(String.format("Could not find the payload for '%s'", wfPayload), (Throwable)e);
        }
    }

    protected void setJcrSessionUserData(ResourceResolver resourceResolver) {
        try {
            ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(EVENT_DATA);
        }
        catch (RepositoryException e) {
            log.warn("Unable to set user-data to [ {} ]", (Object)EVENT_DATA, (Object)e);
        }
    }

    protected void copyProperties(MetaDataMap metaDataMap, ResourceResolver resourceResolver, String payload) {
        String[] propertyMaps;
        Resource resource = this.workflowHelper.getPageOrAssetResource(resourceResolver, payload);
        if (resource == null) {
            log.warn("Could not process payload [ {} ] as it could be resolved to a Page or Asset", (Object)payload);
            return;
        }
        for (String propertyMap : propertyMaps = (String[])metaDataMap.get(PN_PROPERTY_MAP, (Object)new String[0])) {
            propertyMap = StringUtils.replace((String)propertyMap, (String)ALTERNATE_SEPARATOR, (String)SEPARATOR);
            Map.Entry<String, String> entry = ParameterUtil.toMapEntry(propertyMap, SEPARATOR);
            try {
                PropertyResource source = new PropertyResource(StringUtils.trim((String)entry.getKey()), resource.getPath(), resourceResolver);
                PropertyResource destination = new PropertyResource(StringUtils.trim((String)entry.getValue()), resource.getPath(), resourceResolver);
                if (source.propertyExists() && !source.hasValue() && destination.propertyExists()) {
                    log.debug("Remove destination property during copy properties of [ {} -> {} ] because source property exists and has no value, and destination has the property", (Object)source, (Object)destination);
                    destination.setValue(null);
                    continue;
                }
                if (!source.propertyExists() && destination.propertyExists()) {
                    log.debug("Remove destination property during copy properties of [ {} -> {} ] because source property does not exists, and destination has the property", (Object)source, (Object)destination);
                    destination.setValue(null);
                    continue;
                }
                if (source.propertyExists() && !source.hasValue() && !destination.propertyExists()) {
                    log.debug("Do nothing. Skipping [ {} -> {} ] because source has no value, and destination is missing the property", (Object)source, (Object)destination);
                    continue;
                }
                log.debug("Setting [ {} ] value during copy properties of [ {} -> {} ]", new Object[]{source.getValue(), source, destination});
                destination.setValue(source.getValue());
            }
            catch (WorkflowException e) {
                log.error("Could not copy properties [ {} -> {} ] for payload [ {} ]", (Object)new String[]{entry.getKey(), entry.getValue(), resource.getPath()}, (Object)e);
            }
        }
    }

    static class PropertyResource {
        private final String propertyName;
        private final Resource resource;

        public PropertyResource(String mapProperty, String payload, ResourceResolver resourceResolver) throws WorkflowException {
            String resourcePath = StringUtils.substringBeforeLast((String)mapProperty, (String)"/");
            this.propertyName = StringUtils.substringAfterLast((String)mapProperty, (String)"/");
            if (!StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)"/")) {
                resourcePath = PathUtil.makePath((String)payload, (String)resourcePath);
            }
            this.resource = resourceResolver.getResource(resourcePath);
            if (this.resource == null || StringUtils.isBlank((CharSequence)this.propertyName)) {
                throw new WorkflowException(String.format("Unable to parse valid resource and property combination from [ %s + %s ]", payload, mapProperty));
            }
        }

        public boolean propertyExists() {
            return this.resource.getValueMap().containsKey((Object)this.propertyName);
        }

        public boolean hasValue() {
            Object value = this.getValue();
            if (value == null) {
                return false;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                return false;
            }
            return !(value instanceof Object[]) || ((Object[])value).length != 0;
        }

        public Object getValue() {
            return this.resource.getValueMap().get((Object)this.propertyName);
        }

        public void setValue(Object value) {
            ModifiableValueMap properties = (ModifiableValueMap)this.resource.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                if (value != null) {
                    properties.put((Object)this.propertyName, value);
                } else if (properties.containsKey((Object)this.propertyName)) {
                    properties.remove((Object)this.propertyName);
                }
            }
        }

        public String toString() {
            return String.format("%s/%s (Property %s)", this.resource.getPath(), this.propertyName, this.propertyExists() ? "exists" : "does not exist");
        }
    }
}

