/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.Evolution;
import com.adobe.acs.commons.version.EvolutionEntry;
import com.adobe.acs.commons.version.impl.CurrentEvolutionEntryImpl;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentEvolutionImpl
implements Evolution {
    public static final String LATEST_VERSION = "Latest";
    private static final Logger log = LoggerFactory.getLogger(CurrentEvolutionImpl.class);
    private final List<EvolutionEntry> versionEntries = new ArrayList<EvolutionEntry>();

    public CurrentEvolutionImpl(Resource resource, EvolutionConfig config) {
        try {
            this.populate(resource, config, 0);
        }
        catch (RepositoryException e) {
            log.warn("Could not populate Evolution", (Throwable)e);
        }
    }

    @Override
    public boolean isCurrent() {
        return true;
    }

    @Override
    public String getVersionName() {
        return LATEST_VERSION;
    }

    @Override
    public Date getVersionDate() {
        return new Date();
    }

    @Override
    public List<EvolutionEntry> getVersionEntries() {
        return Collections.unmodifiableList(this.versionEntries);
    }

    private void populate(Resource r, EvolutionConfig config, int depth) throws PathNotFoundException, RepositoryException {
        ValueMap map = r.getValueMap();
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Property property = ((Node)r.adaptTo(Node.class)).getProperty(key);
            String relPath = EvolutionPathUtil.getLastRelativePropertyName(property.getPath());
            if (!config.handleProperty(relPath)) continue;
            this.versionEntries.add(new CurrentEvolutionEntryImpl(property, config));
        }
        Iterator iter = r.getChildren().iterator();
        while (iter.hasNext()) {
            ++depth;
            Resource child = (Resource)iter.next();
            String relPath = EvolutionPathUtil.getLastRelativeResourceName(child.getPath());
            if (config.handleResource(relPath)) {
                this.versionEntries.add(new CurrentEvolutionEntryImpl(child, config));
                this.populate(child, config, depth);
            }
            --depth;
        }
    }
}

