/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.day.cq.wcm.api.components.ComponentManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@SlingFilter(scope={SlingFilterScope.REQUEST}, order=-2147483648, generateComponent=false)
public class UrlFilter
implements Filter {
    protected static final String PN_ALLOWED_EXTENSION_PATTERN = "allowedExtensionPattern";
    protected static final String PN_ALLOWED_EXTENSIONS = "allowedExtensions";
    protected static final String PN_ALLOWED_SELECTOR_PATTERN = "allowedSelectorPattern";
    protected static final String PN_ALLOWED_SELECTORS = "allowedSelectors";
    protected static final String PN_ALLOWED_SUFFIX_PATTERN = "allowedSuffixPattern";
    protected static final String PN_ALLOWED_SUFFIXES = "allowedSuffixes";
    private static final Collection<String> PROPERTY_NAMES = Arrays.asList("allowedSuffixes", "allowedExtensions", "allowedSelectors", "allowedSuffixPattern", "allowedSelectorPattern", "allowedExtensionPattern");
    private static final Logger log = LoggerFactory.getLogger(UrlFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest && response instanceof SlingHttpServletResponse) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
            RequestPathInfo pathInfo = slingRequest.getRequestPathInfo();
            com.day.cq.wcm.api.components.Component definitionComponent = this.findUrlFilterDefinitionComponent(slingRequest.getResource(), (ComponentManager)slingRequest.getResourceResolver().adaptTo(ComponentManager.class));
            if (definitionComponent != null) {
                String definitionPath = definitionComponent.getPath();
                log.debug("found url filter definition resource at {}", (Object)definitionPath);
                ValueMap properties = definitionComponent.getProperties();
                if (properties != null) {
                    if (this.checkSelector(pathInfo, properties) && this.checkSuffix(pathInfo, properties) && this.checkExtension(pathInfo, properties)) {
                        log.debug("url filter definition resource at {} passed for request {}.", (Object)definitionPath, (Object)slingRequest.getRequestPathInfo());
                    } else {
                        log.info("url filter definition resource at {} FAILED for request {}.", (Object)definitionPath, (Object)slingRequest.getRequestPathInfo());
                        slingResponse.sendError(403);
                        return;
                    }
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected boolean checkExtension(RequestPathInfo pathInfo, ValueMap properties) {
        return this.check(pathInfo.getExtension(), PN_ALLOWED_EXTENSIONS, PN_ALLOWED_EXTENSION_PATTERN, properties);
    }

    protected boolean checkSelector(RequestPathInfo pathInfo, ValueMap properties) {
        return this.check(pathInfo.getSelectorString(), PN_ALLOWED_SELECTORS, PN_ALLOWED_SELECTOR_PATTERN, properties);
    }

    private boolean check(String value, String allowedArrayPropertyName, String allowedPatternPropertyName, ValueMap properties) {
        if (value == null) {
            return true;
        }
        Object[] allowedValues = (String[])properties.get(allowedArrayPropertyName, String[].class);
        if (allowedValues != null) {
            if (allowedValues.length == 0) {
                log.debug("{} was empty, therefore not allowing any value.", (Object)allowedArrayPropertyName);
                return false;
            }
            if (!ArrayUtils.contains((Object[])allowedValues, (Object)value)) {
                log.debug("{} did not contain our string {}. checking the pattern.", (Object)allowedArrayPropertyName, (Object)value);
                String allowedPattern = (String)properties.get(allowedPatternPropertyName, String.class);
                if (allowedPattern == null || !Pattern.matches(allowedPattern, value)) {
                    log.debug("allowedPattern ({}) did not match our string {}", (Object)allowedPattern, (Object)value);
                    return false;
                }
                log.debug("allowedPattern ({}) did match our string {}", (Object)allowedPattern, (Object)value);
                return true;
            }
            return true;
        }
        String allowedPattern = (String)properties.get(allowedPatternPropertyName, String.class);
        if (allowedPattern != null && !Pattern.matches(allowedPattern, value)) {
            log.debug("allowedPattern ({}) did not match our string {}", (Object)allowedPattern, (Object)value);
            return false;
        }
        return true;
    }

    protected boolean checkSuffix(RequestPathInfo pathInfo, ValueMap properties) {
        return this.check(pathInfo.getSuffix(), PN_ALLOWED_SUFFIXES, PN_ALLOWED_SUFFIX_PATTERN, properties);
    }

    private com.day.cq.wcm.api.components.Component findUrlFilterDefinitionComponent(Resource resource, ComponentManager componentManager) {
        if (resource == null) {
            return null;
        }
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource != null) {
            resource = contentResource;
        }
        com.day.cq.wcm.api.components.Component component = componentManager.getComponentOfResource(resource);
        return this.findUrlFilterDefinitionComponent(component);
    }

    private com.day.cq.wcm.api.components.Component findUrlFilterDefinitionComponent(com.day.cq.wcm.api.components.Component component) {
        if (component == null) {
            return null;
        }
        ValueMap properties = component.getProperties();
        if (!Collections.disjoint(properties.keySet(), PROPERTY_NAMES)) {
            return component;
        }
        return this.findUrlFilterDefinitionComponent(component.getSuperComponent());
    }
}

