/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@EventTopics(value={"org/osgi/framework/BundleEvent/STARTED"})
@Designate(ocd=Config.class)
public class BundleDisabler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(BundleDisabler.class);
    private final BundleContext bundleContext;
    private final Set<String> disabledBundles;

    @Activate
    public BundleDisabler(BundleContext bundleContext, Config config, @Reference(policyOption=ReferencePolicyOption.GREEDY) List<ConfigAmendment> configAmendments) {
        this.bundleContext = bundleContext;
        this.disabledBundles = new HashSet<String>();
        this.disabledBundles.addAll(Arrays.asList(config.bundles()));
        configAmendments.stream().forEach(amendment -> this.disabledBundles.addAll(Arrays.asList(amendment.getConfig().bundles())));
        this.disableBundles();
    }

    public void handleEvent(Event event) {
        this.disableBundles();
    }

    private void disableBundles() {
        if (this.disabledBundles.isEmpty()) {
            log.info("No bundles specified. Consider specifying bundles or removing this service config");
            return;
        }
        log.trace("Disabling bundles {}", this.disabledBundles);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!this.isOnBundleStopList(bundle)) continue;
            try {
                this.disableBundle(bundle);
            }
            catch (BundleException be) {
                log.error("Unable to stop bundle {}", (Object)bundle.getSymbolicName(), (Object)be);
            }
        }
    }

    private void disableBundle(Bundle bundle) throws BundleException {
        if (this.isBundleStoppable(bundle) && this.isNotOwnBundle(bundle)) {
            log.info("Bundle {} disabled by configuration (id={}) ", (Object)bundle.getSymbolicName(), (Object)bundle.getBundleId());
            bundle.stop();
        }
    }

    private boolean isOnBundleStopList(Bundle bundle) {
        return this.disabledBundles.contains(bundle.getSymbolicName());
    }

    private boolean isBundleStoppable(Bundle bundle) {
        return bundle.getState() != 1;
    }

    private boolean isNotOwnBundle(Bundle bundle) {
        return !bundle.equals(this.bundleContext.getBundle());
    }

    @Component(service={ConfigAmendment.class}, property={"webconsole.configurationFactory.nameHint={bundles}"})
    @Designate(factory=true, ocd=Config.class)
    public static final class ConfigAmendment {
        private final Config config;

        @Activate
        public ConfigAmendment(Config config) {
            this.config = config;
        }

        public Config getConfig() {
            return this.config;
        }
    }

    @ObjectClassDefinition(name="ACS AEM Commons - OSGI Bundle Disabler", description="Disables OSGi bundles by configuration")
    static @interface Config {
        @AttributeDefinition(name="Disabled bundles", description="The symbolic names of the bundles you want to disable", cardinality=0x7FFFFFFF)
        public String[] bundles();
    }
}

