/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.datadefinitions.impl;

import com.adobe.acs.commons.util.datadefinitions.ResourceDefinition;
import com.adobe.acs.commons.util.datadefinitions.ResourceDefinitionBuilder;
import com.adobe.acs.commons.util.datadefinitions.impl.BasicResourceDefinition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component
@Properties(value={@Property(name="name", value={"TITLE_AND_NODE_NAME"})})
@Service
public class TitleAndNodeNameDefinitionBuilderImpl
implements ResourceDefinitionBuilder {
    public static final String NAME = "TITLE_AND_NODE_NAME";
    private static final Pattern ACCEPT_PATTERN = Pattern.compile(".+\\{\\{(.+)}}$");
    private static final Pattern PATTERN = Pattern.compile("\\{\\{(.+)}}$");

    @Override
    public final ResourceDefinition convert(String data) {
        Matcher matcher = PATTERN.matcher(data = StringUtils.stripToEmpty((String)data));
        if (!matcher.find() || matcher.groupCount() != 1) {
            return null;
        }
        String name = matcher.group(1);
        name = StringUtils.stripToEmpty((String)name);
        String title = PATTERN.matcher(data).replaceAll("");
        title = StringUtils.stripToEmpty((String)title);
        BasicResourceDefinition dataDefinition = new BasicResourceDefinition(name);
        dataDefinition.setTitle(title);
        return dataDefinition;
    }

    @Override
    public boolean accepts(String data) {
        Matcher matcher = ACCEPT_PATTERN.matcher(data);
        return matcher.matches();
    }
}

