/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import com.adobe.acs.commons.redirects.models.Redirects;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.post.HtmlResponse;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.extensions=txt", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects/redirects"})
public class RewriteMapServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -3564475196678277711L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
            String[] selectors = request.getRequestPathInfo().getSelectors();
            int statusCodeSelector = 0;
            if (selectors != null && selectors.length > 0) {
                statusCodeSelector = Integer.parseInt(selectors[0]);
            }
            List<Resource> rules = Redirects.readRedirects(request.getResource());
            PrintWriter out = response.getWriter();
            out.printf("# %s Redirects\n", statusCodeSelector == 0 ? "All" : "" + statusCodeSelector);
            for (Resource resource : rules) {
                ValueMap props = resource.getValueMap();
                String source = (String)props.get("source", String.class);
                String target = (String)props.get("target", String.class);
                int statusCode = (Integer)props.get("statusCode", Integer.class);
                String note = (String)props.get("note", String.class);
                if (statusCodeSelector != 0 && statusCodeSelector != statusCode) continue;
                if (note != null && !note.isEmpty()) {
                    out.printf("# %s\n", note);
                }
                out.printf("%s %s\n", source.trim(), target.trim());
            }
        }
        catch (IOException e) {
            HtmlResponse htmlResponse = new HtmlResponse();
            htmlResponse.setStatus(500, "Failed to export redirects: " + e.getMessage());
            htmlResponse.send((HttpServletResponse)response, true);
        }
    }
}

