/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ImportLog {
    private final List<Entry> log = new ArrayList<Entry>();
    private String path;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public List<Entry> getLog() {
        this.log.sort(Comparator.comparing(Entry::getLevel).thenComparing(Entry::getCell));
        return this.log;
    }

    public void warn(String cell, String msg) {
        this.log.add(new Entry(Level.WARN, cell, msg));
    }

    public void info(String cell, String msg) {
        this.log.add(new Entry(Level.INFO, cell, msg));
    }

    public static enum Level {
        WARN,
        INFO;

    }

    public static class Entry {
        Level level;
        String cell;
        String msg;

        Entry() {
        }

        Entry(Level level, String cell, String msg) {
            this.level = level;
            this.cell = cell;
            this.msg = msg;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getCell() {
            return this.cell;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

