/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.packaging.impl.AbstractPackagerServlet;
import com.adobe.acs.commons.packaging.util.AssetPackageUtil;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/packager/asset-packager"}, selectors={"package"}, extensions={"json"})
public class AssetPackagerServletImpl
extends AbstractPackagerServlet {
    private static final String DEFAULT_PACKAGE_NAME = "assets";
    private static final String DEFAULT_PACKAGE_GROUP_NAME = "Assets";
    private static final String DEFAULT_PACKAGE_DESCRIPTION = "Asset Package initially defined by a ACS AEM Commons - Asset Packager configuration.";
    private static final String THUMBNAIL_RESOURCE_PATH = "/apps/acs-commons/components/utilities/packager/asset-packager/definition/package-thumbnail.png";
    @Reference
    private transient PackageHelper packageHelper;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        boolean preview = Boolean.parseBoolean(request.getParameter("preview"));
        this.log.debug("Preview mode: {}", (Object)preview);
        ValueMap properties = this.getProperties(request);
        AssetPackageUtil assetPackageUtil = new AssetPackageUtil(properties, resourceResolver);
        try {
            this.doPackaging(request, response, preview, properties, assetPackageUtil.getPackageFilterPaths());
        }
        catch (RepositoryException ex) {
            this.log.error("Repository error while creating Asset Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (IOException ex) {
            this.log.error("IO error while creating Asset Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
    }

    @Override
    protected String getDefaultPackageDescription() {
        return DEFAULT_PACKAGE_DESCRIPTION;
    }

    @Override
    protected String getDefaultPackageGroupName() {
        return DEFAULT_PACKAGE_GROUP_NAME;
    }

    @Override
    protected String getDefaultPackageName() {
        return DEFAULT_PACKAGE_NAME;
    }

    @Override
    protected String getPackageThumbnailPath() {
        return THUMBNAIL_RESOURCE_PATH;
    }

    @Override
    protected PackageHelper getPackageHelper() {
        return this.packageHelper;
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }
}

