/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.ControlledProcessManager;
import com.adobe.acs.commons.mcp.ProcessDefinitionFactory;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.cq.sightly.WCMUsePojo;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AvailableProcessDefinitions
extends WCMUsePojo {
    Map<String, ProcessDefinitionFactory> definitions = Collections.emptyMap();
    Map<String, FieldComponent> fieldComponents = Collections.emptyMap();

    public void activate() throws Exception {
        SlingScriptHelper sling = this.getSlingScriptHelper();
        User user = (User)sling.getRequest().getResourceResolver().adaptTo(User.class);
        ControlledProcessManager cpm = (ControlledProcessManager)sling.getService(ControlledProcessManager.class);
        this.definitions = cpm.getAllProcessDefinitionsForUser(user);
        String processDefinitionName = (String)this.get("processDefinition", String.class);
        if (StringUtils.isEmpty((CharSequence)processDefinitionName)) {
            processDefinitionName = this.getRequest().getParameter("processDefinition");
        }
        this.fieldComponents = cpm.getComponentsForProcessDefinition(processDefinitionName, sling);
    }

    public Map<String, ProcessDefinitionFactory> getDefinitions() {
        return this.definitions;
    }

    public Map<String, FieldComponent> getFieldComponents() {
        return this.fieldComponents;
    }
}

