/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import com.adobe.acs.commons.http.headers.impl.AbstractDispatcherCacheHeaderFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;

public abstract class AbstractExpiresHeaderFilter
extends AbstractDispatcherCacheHeaderFilter {
    protected static final String EXPIRES_NAME = "Expires";
    protected static final String EXPIRES_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String PROP_EXPIRES_TIME = "expires.time";
    private Calendar expiresTime = Calendar.getInstance();

    protected abstract void adjustExpires(Calendar var1);

    @Override
    protected String getHeaderName() {
        return EXPIRES_NAME;
    }

    @Override
    protected String getHeaderValue(HttpServletRequest request) {
        Calendar next = Calendar.getInstance();
        next.set(11, this.expiresTime.get(11));
        next.set(12, this.expiresTime.get(12));
        next.set(13, 0);
        this.adjustExpires(next);
        SimpleDateFormat dateFormat = new SimpleDateFormat(EXPIRES_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(next.getTime());
    }

    @Override
    protected boolean accepts(HttpServletRequest request) {
        if (super.accepts(request)) {
            Enumeration expiresheaders = request.getHeaders(EXPIRES_NAME);
            return expiresheaders == null || !expiresheaders.hasMoreElements();
        }
        return false;
    }

    @Override
    protected void doActivate(ComponentContext context) throws Exception {
        Dictionary properties = context.getProperties();
        String time = PropertiesUtil.toString(properties.get(PROP_EXPIRES_TIME), null);
        if (StringUtils.isBlank((CharSequence)time)) {
            throw new ConfigurationException(PROP_EXPIRES_TIME, "Expires Time must be specified.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        sdf.setLenient(false);
        try {
            Date date = sdf.parse(time);
            this.expiresTime.setTime(date);
        }
        catch (ParseException ex) {
            throw new ConfigurationException(PROP_EXPIRES_TIME, "Expires Time must be specified.");
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getHeaderValue(null) + "]";
    }
}

