/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ccvar.util;

import com.adobe.acs.commons.ccvar.TransformAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ContentVariableReplacementUtil {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\(\\(([a-zA-Z0-9_:\\-]+\\.[a-zA-Z0-9_:\\-]+(![a-zA-Z0-9_:\\-]*)?)\\)\\)");
    private static final Map<String, String> REQUIRED_ESCAPE = ContentVariableReplacementUtil.escapeMap();
    private static final String PLACEHOLDER_BEGIN = "((";
    private static final String PLACEHOLDER_END = "))";

    private ContentVariableReplacementUtil() {
    }

    public static String getPlaceholder(String key) {
        return PLACEHOLDER_BEGIN + key + PLACEHOLDER_END;
    }

    public static boolean hasKey(Map<String, Object> contentVariableReplacements, String key) {
        if (StringUtils.contains((CharSequence)key, (CharSequence)"!")) {
            String keyWithoutAction = StringUtils.substringBefore((String)key, (String)"!");
            return contentVariableReplacements.containsKey(keyWithoutAction);
        }
        return contentVariableReplacements.containsKey(key);
    }

    public static Object getValue(Map<String, Object> contentVariableReplacements, String key) {
        if (StringUtils.contains((CharSequence)key, (CharSequence)"!")) {
            String keyWithoutAction = StringUtils.substringBefore((String)key, (String)"!");
            return contentVariableReplacements.get(keyWithoutAction);
        }
        return contentVariableReplacements.get(key);
    }

    public static List<String> getKeys(String string) {
        ArrayList<String> keys = new ArrayList<String>();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(string);
        while (matcher.find()) {
            keys.add(StringUtils.substringBetween((String)StringUtils.defaultString((String)matcher.group()), (String)PLACEHOLDER_BEGIN, (String)PLACEHOLDER_END));
        }
        return keys;
    }

    public static String doReplacement(String input, String key, String replacement, TransformAction action) {
        if (action != null) {
            if (action.disableEscaping()) {
                return input.replace(ContentVariableReplacementUtil.getPlaceholder(key), action.execute(replacement));
            }
            return input.replace(ContentVariableReplacementUtil.getPlaceholder(key), ContentVariableReplacementUtil.baseEscaping(action.execute(replacement)));
        }
        return input.replace(ContentVariableReplacementUtil.getPlaceholder(key), ContentVariableReplacementUtil.baseEscaping(replacement));
    }

    private static String baseEscaping(String input) {
        for (Map.Entry<String, String> entry : REQUIRED_ESCAPE.entrySet()) {
            if (!input.contains(entry.getKey())) continue;
            input = input.replace(entry.getKey(), entry.getValue());
        }
        return input;
    }

    private static Map<String, String> escapeMap() {
        HashMap<String, String> escapes = new HashMap<String, String>();
        escapes.put("\"", "&quot;");
        escapes.put("'", "&apos;");
        escapes.put("<", "&lt;");
        escapes.put(">", "&gt;");
        return escapes;
    }
}

