/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.aep.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.http.Cookie;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/bin/aep/fpid", "sling.servlet.methods=GET"})
public class FpidCookieServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(FpidCookieServlet.class);
    private static final String COOKIE_NAME = "FPID";
    private static final String COOKIE_PATH = "/";
    private static final int COOKIE_MAX_AGE = 0x2022900;
    private static final String JSON_KEY = "fpid";

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Cookie existingCookie = request.getCookie(COOKIE_NAME);
        String cookieValue = existingCookie == null ? UUID.randomUUID().toString() : existingCookie.getValue();
        response.addHeader("Set-Cookie", "FPID=" + cookieValue + "; Max-Age=" + 0x2022900 + "; Path=" + COOKIE_PATH + "; HttpOnly; Secure; SameSite=Lax");
        response.addHeader("Cache-Control", "no-store");
        JsonObject json = new JsonObject();
        json.addProperty(JSON_KEY, cookieValue);
        response.setContentType("application/json");
        response.getWriter().write(json.toString());
    }
}

