/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.fam.impl.ThrottledTaskRunnerStats;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Failure;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"status"}, extensions={"json"})
public class StatusServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(StatusServlet.class);
    private static final int DECIMAL_TO_PERCENT = 100;
    @Reference
    private transient ThrottledTaskRunnerStats ttrs;
    @Reference
    private transient ActionManagerFactory actionManagerFactory;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        JsonArray failures;
        ActionManager actionManager;
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss aaa");
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Config config = (Config)request.getResource().adaptTo(Config.class);
        Workspace workspace = config.getWorkspace();
        JsonObject json = new JsonObject();
        json.addProperty("initialized", Boolean.valueOf(workspace.isInitialized()));
        json.addProperty("status", workspace.getStatus().name());
        if (workspace.getSubStatus() != null) {
            json.addProperty("subStatus", workspace.getSubStatus().name());
        }
        json.addProperty("runnerType", config.getRunnerType());
        json.addProperty("queryType", config.getQueryType());
        json.addProperty("queryStatement", config.getQueryStatement());
        json.addProperty("workflowModel", StringUtils.removeEnd((String)config.getWorkflowModelId(), (String)"/jcr:content/model"));
        json.addProperty("batchSize", (Number)config.getBatchSize());
        json.addProperty("autoThrottle", Boolean.valueOf(config.isAutoThrottle()));
        json.addProperty("purgeWorkflow", Boolean.valueOf(config.isPurgeWorkflow()));
        json.addProperty("interval", (Number)config.getInterval());
        json.addProperty("retryCount", (Number)config.getRetryCount());
        json.addProperty("timeout", (Number)config.getTimeout());
        json.addProperty("throttle", (Number)config.getThrottle());
        json.addProperty("message", workspace.getMessage());
        if (config.isUserEventData()) {
            json.addProperty("userEventData", config.getUserEventData());
        }
        if ((actionManager = this.actionManagerFactory.getActionManager(workspace.getActionManagerName())) != null && !Status.COMPLETED.equals((Object)workspace.getStatus())) {
            failures = new JsonArray();
            json.add("failures", (JsonElement)failures);
            this.addActionManagerTrackedCounts(workspace.getActionManagerName(), json);
            for (com.adobe.acs.commons.fam.Failure failure : actionManager.getFailureList()) {
                JsonObject failureJSON = new JsonObject();
                failureJSON.addProperty("payloadPath", failure.getNodePath());
                failureJSON.addProperty("failedAt", sdf.format(failure.getTime().getTime()));
                failures.add((JsonElement)failureJSON);
            }
        } else {
            this.addWorkspaceTrackedCounts(workspace, json);
            failures = new JsonArray();
            json.add("failures", (JsonElement)failures);
            for (Failure failure : workspace.getFailures()) {
                failures.add((JsonElement)failure.toJSON());
            }
        }
        if (workspace.getStartedAt() != null) {
            json.addProperty("startedAt", sdf.format(workspace.getStartedAt().getTime()));
            json.addProperty("timeTakenInMillis", (Number)(Calendar.getInstance().getTime().getTime() - workspace.getStartedAt().getTime().getTime()));
        }
        if (workspace.getStoppedAt() != null) {
            json.addProperty("stoppedAt", sdf.format(workspace.getStoppedAt().getTime()));
            json.addProperty("timeTakenInMillis", (Number)(workspace.getStoppedAt().getTime().getTime() - workspace.getStartedAt().getTime().getTime()));
        }
        if (workspace.getCompletedAt() != null) {
            json.addProperty("completedAt", sdf.format(workspace.getCompletedAt().getTime()));
            json.addProperty("timeTakenInMillis", (Number)(workspace.getCompletedAt().getTime().getTime() - workspace.getStartedAt().getTime().getTime()));
        }
        if (AEMWorkflowRunnerImpl.class.getName().equals(config.getRunnerType())) {
            JsonArray activePayloads = new JsonArray();
            json.add("activePayloads", (JsonElement)activePayloads);
            for (Payload payload : config.getWorkspace().getActivePayloads()) {
                activePayloads.add((JsonElement)payload.toJSON());
            }
        }
        json.add("systemStats", (JsonElement)this.getSystemStats());
        Gson gson = new Gson();
        gson.toJson((JsonElement)json, (Appendable)response.getWriter());
    }

    private void addActionManagerTrackedCounts(String name, JsonObject json) {
        ActionManager actionManager = this.actionManagerFactory.getActionManager(name);
        int failureCount = actionManager.getErrorCount();
        int completeCount = actionManager.getSuccessCount();
        int totalCount = actionManager.getAddedCount();
        int remainingCount = actionManager.getRemainingCount();
        json.addProperty("totalCount", (Number)totalCount);
        json.addProperty("completeCount", (Number)completeCount);
        json.addProperty("remainingCount", (Number)remainingCount);
        json.addProperty("failCount", (Number)failureCount);
        json.addProperty("percentComplete", (Number)Math.round((float)(totalCount - remainingCount) / ((float)totalCount * 1.0f) * 100.0f));
    }

    private void addWorkspaceTrackedCounts(Workspace workspace, JsonObject json) {
        int remainingCount = workspace.getTotalCount() - (workspace.getCompleteCount() + workspace.getFailCount());
        json.addProperty("totalCount", (Number)workspace.getTotalCount());
        json.addProperty("completeCount", (Number)workspace.getCompleteCount());
        json.addProperty("remainingCount", (Number)remainingCount);
        json.addProperty("failCount", (Number)workspace.getFailCount());
        json.addProperty("percentComplete", (Number)Math.round((float)(workspace.getTotalCount() - remainingCount) / ((float)workspace.getTotalCount() * 1.0f) * 100.0f));
    }

    private JsonObject getSystemStats() {
        JsonObject json = new JsonObject();
        try {
            json.addProperty("cpu", MessageFormat.format("{0,number,#%}", this.ttrs.getCpuLevel()));
        }
        catch (InstanceNotFoundException e) {
            log.error("Could not collect CPU stats", (Throwable)e);
            json.addProperty("cpu", (Number)-1);
        }
        catch (ReflectionException e) {
            log.error("Could not collect CPU stats", (Throwable)e);
            json.addProperty("cpu", (Number)-1);
        }
        json.addProperty("mem", MessageFormat.format("{0,number,#%}", this.ttrs.getMemoryUsage()));
        json.addProperty("maxCpu", MessageFormat.format("{0,number,#%}", this.ttrs.getMaxCpu()));
        json.addProperty("maxMem", MessageFormat.format("{0,number,#%}", this.ttrs.getMaxHeap()));
        return json;
    }

    protected void bindTtrs(ThrottledTaskRunnerStats throttledTaskRunnerStats) {
        this.ttrs = throttledTaskRunnerStats;
    }

    protected void unbindTtrs(ThrottledTaskRunnerStats throttledTaskRunnerStats) {
        if (this.ttrs == throttledTaskRunnerStats) {
            this.ttrs = null;
        }
    }

    protected void bindActionManagerFactory(ActionManagerFactory actionManagerFactory) {
        this.actionManagerFactory = actionManagerFactory;
    }

    protected void unbindActionManagerFactory(ActionManagerFactory actionManagerFactory) {
        if (this.actionManagerFactory == actionManagerFactory) {
            this.actionManagerFactory = null;
        }
    }
}

