/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public final class DesignReferenceProvider
implements ReferenceProvider {
    private static final String TYPE_DESIGN_PAGE = "designpage";

    public List<Reference> findReferences(Resource resource) {
        ResourceResolver resourceResolver = resource.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Designer designer = (Designer)resourceResolver.adaptTo(Designer.class);
        Page page = pageManager.getContainingPage(resource);
        if (page == null) {
            return Collections.emptyList();
        }
        Design design = designer.getDesign(page);
        if (design == null) {
            return Collections.emptyList();
        }
        Resource contentResource = design.getContentResource();
        if (contentResource == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Reference(TYPE_DESIGN_PAGE, String.format("%s (Design)", design.getId()), contentResource, this.getLastModified(design)));
    }

    private long getLastModified(Design design) {
        Calendar mod = design.getLastModified();
        long lastModified = mod != null ? mod.getTimeInMillis() : -1L;
        return lastModified;
    }
}

