/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl.lines;

import acscommons.com.google.common.base.Function;
import acscommons.com.google.common.collect.FluentIterable;
import acscommons.com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.List;

class Stepper<T> {
    private final List<Serializable> ids;
    private final Iterable<T> values;
    private final Function<T, Serializable> toId;
    private int step = 0;

    Stepper(Iterable<T> steps, Function<T, Serializable> toId) {
        this.toId = toId;
        this.values = steps;
        this.ids = FluentIterable.from(steps).transform(toId).toList();
    }

    public T next() {
        T ret = Iterables.size(this.values) > this.step ? (T)Iterables.get(this.values, this.step) : null;
        ++this.step;
        return ret;
    }

    public int positionOfIdAfterCurrent(T t) {
        if (t != null) {
            Serializable searchId = this.toId.apply(t);
            for (int i = this.step; i < this.ids.size(); ++i) {
                if (!this.ids.get(i).equals(searchId)) continue;
                return i + 1 - this.step;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.step >= this.ids.size();
    }
}

