/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import com.adobe.acs.commons.util.mbeans.ResourceServiceManagerMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceServiceManager
extends AnnotatedStandardMBean
implements ResourceServiceManagerMBean,
EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceServiceManager.class);
    public static final String SERVICE_OWNER_KEY = "service.owner";
    public static final String CONFIGURATION_ID_KEY = "configuration.id";
    private BundleContext bctx;
    private Map<String, ServiceRegistration> registeredServices = new HashMap<String, ServiceRegistration>();

    protected ResourceServiceManager(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    @Activate
    public synchronized void activate(ComponentContext context) throws LoginException {
        log.trace("activate");
        this.bctx = context.getBundleContext();
        this.refreshCache();
        log.trace("Activation successful!");
    }

    @Deactivate
    public synchronized void deactivate(ComponentContext context) throws LoginException {
        log.trace("deactivate");
        for (String id : this.registeredServices.keySet()) {
            this.unregisterService(id);
        }
        log.trace("Deactivation successful!");
    }

    public BundleContext getBundleContext() {
        return this.bctx;
    }

    @Override
    public List<String> getRegisteredConfigurations() {
        ArrayList<String> registeredConfigurations = new ArrayList<String>();
        registeredConfigurations.addAll(this.registeredServices.keySet());
        return registeredConfigurations;
    }

    public Map<String, ServiceRegistration> getRegisteredServices() {
        return this.registeredServices;
    }

    protected abstract ResourceResolver getResourceResolver();

    public abstract String getRootPath();

    public void handleEvent(Event event) {
        log.trace("handleEvent");
        this.refreshCache();
    }

    protected abstract boolean isServiceUpdated(Resource var1, ServiceReference var2);

    @Override
    public synchronized void refreshCache() {
        log.trace("refreshCache");
        try (ResourceResolver resolver = this.getResourceResolver();){
            Resource aprRoot = resolver.getResource(this.getRootPath());
            if (aprRoot == null) {
                log.error("Root path for service resource not found: {}", (Object)this.getRootPath());
                return;
            }
            ArrayList<String> configuredIds = new ArrayList<String>();
            for (Resource child : aprRoot.getChildren()) {
                if ("jcr:content".equals(child.getName())) continue;
                log.debug("Updating service for configuration {}", (Object)child.getPath());
                this.updateJobService(child.getPath(), child.getChild("jcr:content"));
                configuredIds.add(child.getPath());
            }
            String filter = "(service.owner=" + this.getClass().getCanonicalName() + ")";
            ServiceReference[] serviceReferences = (ServiceReference[])ArrayUtils.addAll((Object[])this.bctx.getServiceReferences(Runnable.class.getCanonicalName(), filter), (Object[])this.bctx.getServiceReferences(EventHandler.class.getCanonicalName(), filter));
            if (serviceReferences != null && serviceReferences.length > 0) {
                log.debug("Found {} registered services", (Object)serviceReferences.length);
                for (ServiceReference reference : serviceReferences) {
                    try {
                        String configurationId = (String)reference.getProperty(CONFIGURATION_ID_KEY);
                        if (configuredIds.contains(configurationId)) continue;
                        log.debug("Unregistering service for configuration {}", (Object)configurationId);
                        this.unregisterService(configurationId);
                    }
                    catch (Exception e) {
                        log.warn("Exception unregistering reference " + reference, (Throwable)e);
                    }
                }
            } else {
                log.debug("Did not find any registered services.");
            }
        }
        catch (InvalidSyntaxException e) {
            log.warn("Unable to search for invalid references due to invalid filter format", (Throwable)e);
        }
    }

    private ServiceRegistration registerService(String id, Resource config) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put(SERVICE_OWNER_KEY, this.getClass().getCanonicalName());
        props.put(CONFIGURATION_ID_KEY, id);
        ServiceRegistration serviceRegistration = this.registerServiceObject(config, props);
        this.registeredServices.put(id, serviceRegistration);
        log.debug("Automatic Package Replication job {} successfully updated with service {}", (Object)id, serviceRegistration.getReference().getProperty("service.id"));
        return serviceRegistration;
    }

    protected abstract ServiceRegistration registerServiceObject(Resource var1, Hashtable<String, Object> var2);

    private void unregisterService(String id) {
        log.debug("Unregistering job: {}", (Object)id);
        try {
            ServiceRegistration registration = this.registeredServices.remove(id);
            if (registration != null) {
                registration.unregister();
            }
            log.debug("Job {} registered successfully!", (Object)id);
        }
        catch (Exception e) {
            log.warn("Exception unregistering job " + id, (Throwable)e);
        }
    }

    private void updateJobService(String id, Resource resource) {
        log.debug("Registering job: {}", (Object)id);
        try {
            String filter = "(&(service.owner=" + this.getClass().getCanonicalName() + ")(" + CONFIGURATION_ID_KEY + "=" + id + "))";
            ServiceReference[] serviceReferences = (ServiceReference[])ArrayUtils.addAll((Object[])this.bctx.getServiceReferences(Runnable.class.getCanonicalName(), filter), (Object[])this.bctx.getServiceReferences(EventHandler.class.getCanonicalName(), filter));
            if (serviceReferences != null && serviceReferences.length > 0) {
                ServiceReference sr = serviceReferences[0];
                if (this.isServiceUpdated(resource, sr)) {
                    log.debug("Service for {} up to date, no changes necessary", (Object)id);
                } else {
                    log.warn("Unbinding ServiceReference for {}", (Object)id);
                    this.unregisterService(id);
                    this.registerService(id, resource);
                }
            } else {
                this.registerService(id, resource);
            }
        }
        catch (Exception e) {
            log.error("Failed to register job " + id, (Throwable)e);
        }
    }
}

