/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.EnsureAuthorizableException;
import com.adobe.acs.commons.util.ParameterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ace {
    private static final Logger log = LoggerFactory.getLogger(Ace.class);
    private static final String PARAM_DELIMITER = ";";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String LIST_SEPARATOR = ",";
    private static final String PROP_TYPE = "type";
    private static final String PROP_PATH = "path";
    private static final String PROP_PRIVILEGES = "privileges";
    private static final String PROP_REP_GLOB = "rep:glob";
    private static final String PROP_REP_NT_NAMES = "rep:ntNames";
    private static final String PROP_REP_ITEM_NAMES = "rep:itemNames";
    private static final String PROP_REP_PREFIXES = "rep:prefixes";
    private String type;
    private String path;
    private String repGlob = null;
    private List<String> repNtNames = new ArrayList<String>();
    private List<String> repItemNames = new ArrayList<String>();
    private List<String> repPrefixes = new ArrayList<String>();
    private final List<String> privilegeNames = new ArrayList<String>();
    private boolean exists = false;

    public Ace(String raw) throws EnsureAuthorizableException {
        String[] segments;
        for (String segment : segments = StringUtils.split((String)raw, (String)PARAM_DELIMITER)) {
            Map.Entry<String, String> entry = ParameterUtil.toMapEntry(segment, KEY_VALUE_SEPARATOR);
            if (entry == null) continue;
            if (StringUtils.equals((CharSequence)PROP_TYPE, (CharSequence)entry.getKey())) {
                this.type = StringUtils.stripToNull((String)entry.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)PROP_PATH, (CharSequence)entry.getKey())) {
                this.path = StringUtils.stripToNull((String)entry.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)PROP_REP_GLOB, (CharSequence)entry.getKey())) {
                this.repGlob = StringUtils.stripToEmpty((String)entry.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)PROP_REP_NT_NAMES, (CharSequence)entry.getKey())) {
                this.repNtNames.addAll(Arrays.asList(StringUtils.split((String)StringUtils.stripToEmpty((String)entry.getValue()), (String)LIST_SEPARATOR)));
                continue;
            }
            if (StringUtils.equals((CharSequence)PROP_REP_ITEM_NAMES, (CharSequence)entry.getKey())) {
                this.repItemNames.addAll(Arrays.asList(StringUtils.split((String)StringUtils.stripToEmpty((String)entry.getValue()), (String)LIST_SEPARATOR)));
                continue;
            }
            if (StringUtils.equals((CharSequence)PROP_REP_PREFIXES, (CharSequence)entry.getKey())) {
                this.repPrefixes.addAll(Arrays.asList(StringUtils.split((String)StringUtils.stripToEmpty((String)entry.getValue()), (String)LIST_SEPARATOR)));
                continue;
            }
            if (!StringUtils.equals((CharSequence)PROP_PRIVILEGES, (CharSequence)entry.getKey())) continue;
            for (String privilege : StringUtils.split((String)entry.getValue(), (String)LIST_SEPARATOR)) {
                if ((privilege = StringUtils.stripToNull((String)privilege)) == null) continue;
                this.privilegeNames.add(privilege);
            }
        }
        this.validate(this.type, this.path, this.privilegeNames);
    }

    protected void validate(String type, String path, List<String> privilegeNames) throws EnsureAuthorizableException {
        if (!ArrayUtils.contains((Object[])new String[]{"allow", "deny"}, (Object)type)) {
            throw new EnsureAuthorizableException("Ensure Service User requires valid type. [ " + type + " ] type is invalid");
        }
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            throw new EnsureAuthorizableException("Ensure Service User requires an absolute path. [ " + path + " ] path is invalid");
        }
        if (privilegeNames.size() < 1) {
            throw new EnsureAuthorizableException("Ensure Service User requires at least 1 privilege to apply.");
        }
    }

    public boolean isAllow() {
        return StringUtils.equals((CharSequence)"allow", (CharSequence)this.type);
    }

    public String getContentPath() {
        return this.path;
    }

    public List<String> getPrivilegeNames() {
        return Collections.unmodifiableList(this.privilegeNames);
    }

    public List<Privilege> getPrivileges(AccessControlManager accessControlManager) {
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        for (String privilegeName : this.getPrivilegeNames()) {
            try {
                privileges.add(accessControlManager.privilegeFromName(privilegeName));
            }
            catch (RepositoryException e) {
                log.error("Unable to convert provided privilege name [ {} ] to a JCR Privilege. Skipping...", (Object)privilegeName);
            }
        }
        return privileges;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getRepGlob() {
        return this.repGlob;
    }

    public boolean hasRepGlob() {
        return this.getRepGlob() != null;
    }

    public List<String> getRepNtNames() {
        return Collections.unmodifiableList(this.repNtNames);
    }

    public boolean hasRepNtNames() {
        return !this.getRepNtNames().isEmpty();
    }

    public List<String> getRepItemNames() {
        return Collections.unmodifiableList(this.repItemNames);
    }

    public boolean hasRepItemNames() {
        return !this.getRepItemNames().isEmpty();
    }

    public List<String> getRepPrefixes() {
        return Collections.unmodifiableList(this.repPrefixes);
    }

    public boolean hasRepPrefixes() {
        return !this.getRepPrefixes().isEmpty();
    }

    public boolean isSameAs(JackrabbitAccessControlEntry actual) throws RepositoryException {
        if (actual.isAllow() != this.isAllow()) {
            return false;
        }
        List<String> actualPrivileges = Arrays.asList(AccessControlUtils.namesFromPrivileges((Privilege[])actual.getPrivileges()));
        if (!CollectionUtils.isEqualCollection(actualPrivileges, this.getPrivilegeNames())) {
            return false;
        }
        if (!this.isRestrictionValid(this.hasRepGlob(), actual.getRestrictions(PROP_REP_GLOB), Arrays.asList(this.getRepGlob()))) {
            return false;
        }
        if (!this.isRestrictionValid(this.hasRepNtNames(), actual.getRestrictions(PROP_REP_NT_NAMES), this.getRepNtNames())) {
            return false;
        }
        if (!this.isRestrictionValid(this.hasRepItemNames(), actual.getRestrictions(PROP_REP_ITEM_NAMES), this.getRepItemNames())) {
            return false;
        }
        return this.isRestrictionValid(this.hasRepPrefixes(), actual.getRestrictions(PROP_REP_PREFIXES), this.getRepPrefixes());
    }

    private boolean isRestrictionValid(boolean configExists, Value[] actualValues, List<String> configValues) {
        ArrayList<String> actualRestrictions = new ArrayList<String>();
        if (configExists && actualValues == null) {
            return false;
        }
        if (!configExists && actualValues != null) {
            return false;
        }
        if (configExists && actualValues != null) {
            for (Value value : actualValues) {
                actualRestrictions.add(value.toString());
            }
            if (!CollectionUtils.isEqualCollection(actualRestrictions, configValues)) {
                return false;
            }
        }
        return true;
    }
}

