/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportException;
import com.adobe.acs.commons.reports.api.ReportExecutor;
import com.adobe.acs.commons.reports.internal.ReportExecutorProvider;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ReportRunner {
    private static final Logger log = LoggerFactory.getLogger(ReportRunner.class);
    public static final String PN_EXECUTOR = "reportExecutor";
    private String failureMessage;
    private ReportExecutor reportExecutor;
    private SlingHttpServletRequest request;
    private boolean succeeded = true;
    @OSGiService
    private DynamicClassLoaderManager dynamicClassLoaderManager;

    public ReportRunner(SlingHttpServletRequest request) {
        this.request = request;
    }

    ReportRunner(SlingHttpServletRequest request, DynamicClassLoaderManager dynamicClassLoaderManager) {
        this(request);
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    private boolean executeConfig(Resource config, SlingHttpServletRequest request, int page) {
        log.trace("executeConfig");
        try {
            Class<?> exClass = ReportExecutorProvider.INSTANCE.getReportExecutor(this.dynamicClassLoaderManager, config);
            Object model = request.adaptTo(exClass);
            if (model instanceof ReportExecutor) {
                ReportExecutor ex = (ReportExecutor)model;
                ex.setConfiguration(config);
                ex.setPage(page);
                this.reportExecutor = ex;
                return true;
            }
            log.warn("Class {} is not an instance of ReportExecutor", (Object)this.reportExecutor);
        }
        catch (ReportException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Unexpected exception executing report executor {} ", (Object)this.reportExecutor, (Object)e);
        }
        return false;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public ReportExecutor getReportExecutor() {
        return this.reportExecutor;
    }

    @PostConstruct
    protected void init() {
        int page;
        log.trace("init");
        try {
            page = Integer.parseInt(this.request.getParameter("page"), 10);
        }
        catch (Exception e) {
            page = 0;
        }
        Resource configCtr = this.request.getResource().getChild("config");
        boolean resultsRetrieved = false;
        if (configCtr != null && configCtr.listChildren().hasNext()) {
            Iterator children = configCtr.listChildren();
            while (children.hasNext()) {
                Resource config = (Resource)children.next();
                if (this.executeConfig(config, this.request, page)) {
                    log.debug("Successfully executed report with configuration: {}", (Object)config);
                    resultsRetrieved = true;
                    break;
                }
                log.warn("Unable to execute report for configuration: {}", (Object)config);
            }
        } else {
            log.warn("No configurations found for {}", (Object)this.request.getResource());
            this.succeeded = false;
            this.failureMessage = "No configurations found!";
            return;
        }
        if (!resultsRetrieved) {
            log.warn("No results were retrieved for {}", (Object)this.request.getResource());
            this.succeeded = false;
            this.failureMessage = "No results retrieved!";
        }
    }

    public boolean isSuccessful() {
        return this.succeeded;
    }
}

