/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.internal;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DelimiterConfiguration.class})
@Designate(ocd=Config.class)
public class DelimiterConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelimiterConfiguration.class);
    public static final String DEFAULT_FIELD_DELIMITER = ",";
    public static final String DEFAULT_MULTI_VALUE_DELIMITER = ";";
    private String fieldDelimiter;
    private String multiValueDelimiter;

    @Modified
    @Activate
    public void configurationModified(Config config) {
        LOGGER.info("Activating/updating service");
        this.fieldDelimiter = config.field_delimiter();
        this.multiValueDelimiter = config.multi_value_delimiter();
        LOGGER.info("Activated/updated service: {}", (Object)this);
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getMultiValueDelimiter() {
        return this.multiValueDelimiter;
    }

    public String toString() {
        return "DelimiterConfiguration{fieldDelimiter='" + this.fieldDelimiter + '\'' + ", multiValueDelimiter='" + this.multiValueDelimiter + '\'' + '}';
    }

    @ObjectClassDefinition(name="ACS Commons - Report CSV Delimiter Configuration")
    static @interface Config {
        @AttributeDefinition(name="Field Delimiter", description="The delimiter to use to limit fields.")
        public String field_delimiter() default ",";

        @AttributeDefinition(name="Multi-value Delimiter", description="The delimiter to use in multi-value fields.")
        public String multi_value_delimiter() default ";";
    }
}

