/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.packages.automatic.impl;

import com.adobe.acs.commons.replication.packages.automatic.AutomaticPackageReplicatorMBean;
import com.adobe.acs.commons.replication.packages.automatic.impl.AutomaticPackageReplicatorJob;
import com.adobe.acs.commons.replication.packages.automatic.model.AutomaticPackageReplicatorModel;
import com.adobe.acs.commons.util.ResourceServiceManager;
import com.day.cq.replication.Replicator;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={ResourceChangeListener.class, AutomaticPackageReplicatorMBean.class})
@Properties(value={@Property(name="jmx.objectname", value={"com.adobe.acs.commons:type=Automatic Package Replicator"}), @Property(name="resource.change.types", value={"ADDED", "CHANGED", "REMOVED"}), @Property(name="resource.paths", value={"glob:/etc/acs-commons/automatic-package-replication/**/jcr:content"})})
public class ConfigurationUpdateListener
extends ResourceServiceManager
implements ResourceChangeListener,
ExternalResourceChangeListener,
AutomaticPackageReplicatorMBean {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUpdateListener.class);
    private static final String ROOT_PATH = "/etc/acs-commons/automatic-package-replication";
    private static final String TRIGGER_KEY = "trigger.name";
    private static final String SERVICE_NAME = "automatic-package-replicator";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "automatic-package-replicator");
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private Replicator replicator;
    @Reference
    private EventAdmin eventAdmin;

    static final ResourceResolver getResourceResolver(ResourceResolverFactory factory) {
        ResourceResolver resolver = null;
        try {
            resolver = factory.getServiceResourceResolver(AUTH_INFO);
        }
        catch (LoginException e) {
            log.error("Exception allocating resource resolver", (Throwable)e);
        }
        return resolver;
    }

    @Override
    protected ResourceResolver getResourceResolver() {
        return ConfigurationUpdateListener.getResourceResolver(this.resourceResolverFactory);
    }

    public ConfigurationUpdateListener() throws NotCompliantMBeanException {
        super(AutomaticPackageReplicatorMBean.class);
    }

    protected ConfigurationUpdateListener(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    @Override
    public void execute(String id) {
        AutomaticPackageReplicatorJob job = (AutomaticPackageReplicatorJob)this.getBundleContext().getService(super.getRegisteredServices().get(id).getReference());
        job.run();
    }

    @Override
    protected boolean isServiceUpdated(Resource config, ServiceReference reference) {
        boolean updated = false;
        AutomaticPackageReplicatorModel model = new AutomaticPackageReplicatorModel(config);
        String triggerStr = (String)reference.getProperty(TRIGGER_KEY);
        if (model.getTrigger() == AutomaticPackageReplicatorModel.TRIGGER.cron && model.getTrigger() == AutomaticPackageReplicatorModel.TRIGGER.valueOf(triggerStr) && ObjectUtils.equals((Object)reference.getProperty("scheduler.expression"), (Object)model.getCronTrigger())) {
            updated = true;
        } else if (model.getTrigger() == AutomaticPackageReplicatorModel.TRIGGER.event && model.getTrigger() == AutomaticPackageReplicatorModel.TRIGGER.valueOf(triggerStr) && ObjectUtils.equals((Object)reference.getProperty("event.topics"), (Object)model.getEventTopic()) && ObjectUtils.equals((Object)reference.getProperty("event.filter"), (Object)model.getEventFilter())) {
            updated = true;
        }
        return updated;
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    @Override
    protected ServiceRegistration registerServiceObject(Resource config, Hashtable<String, Object> props) {
        AutomaticPackageReplicatorModel model = new AutomaticPackageReplicatorModel(config);
        AutomaticPackageReplicatorJob job = new AutomaticPackageReplicatorJob(this.resourceResolverFactory, this.replicator, this.eventAdmin, model.getPackagePath());
        ServiceRegistration serviceRegistration = null;
        props.put(TRIGGER_KEY, model.getTrigger().name());
        if (AutomaticPackageReplicatorModel.TRIGGER.cron == model.getTrigger()) {
            if (StringUtils.isEmpty((CharSequence)model.getCronTrigger())) {
                throw new IllegalArgumentException("No cron trigger specified");
            }
            props.put("scheduler.expression", model.getCronTrigger());
            log.debug("Registering cron runner with: {}", props);
            serviceRegistration = super.getBundleContext().registerService(Runnable.class.getCanonicalName(), (Object)job, props);
        } else {
            if (StringUtils.isEmpty((CharSequence)model.getEventTopic())) {
                throw new IllegalArgumentException("No event topic specified");
            }
            props.put("event.topics", new String[]{model.getEventTopic()});
            if (StringUtils.isNotEmpty((CharSequence)model.getEventFilter())) {
                props.put("event.filter", model.getEventFilter());
            }
            log.debug("Registering event handler runner with: {}", props);
            serviceRegistration = super.getBundleContext().registerService(EventHandler.class.getCanonicalName(), (Object)job, props);
        }
        return serviceRegistration;
    }

    public void onChange(List<ResourceChange> changes) {
        this.refreshCache();
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

