/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import acscommons.com.google.common.collect.Lists;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.Session;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class Redirects {
    public static final String CFG_PROP_CONTEXT_PREFIX = "contextPrefix";
    public static final String CFG_PROP_IGNORE_SELECTORS = "ignoreSelectors";
    public static final String CFG_PROP_PAGE_SIZE = "pageSize";
    private static final Logger log = LoggerFactory.getLogger(Redirects.class);
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService
    private QueryBuilder queryBuilder;
    int pageNumber = 1;
    int pageSize = 100;
    List<List<Resource>> pages;
    String contextPrefix;
    boolean ignoreSelectors;

    @PostConstruct
    protected void init() {
        Resource configResource = this.request.getRequestPathInfo().getSuffixResource();
        ValueMap properties = configResource.getValueMap();
        this.contextPrefix = (String)properties.get(CFG_PROP_CONTEXT_PREFIX, (Object)"");
        this.ignoreSelectors = (Boolean)properties.get(CFG_PROP_IGNORE_SELECTORS, (Object)false);
        this.pageSize = (Integer)properties.get(CFG_PROP_PAGE_SIZE, (Object)100);
        if (ArrayUtils.contains((Object[])this.request.getRequestPathInfo().getSelectors(), (Object)"search")) {
            this.pages = Collections.singletonList(this.search(this.request.getParameter("term"), configResource.getPath()));
            this.pageNumber = 1;
        } else {
            String pg = this.request.getParameter("page");
            if (pg != null) {
                this.pageNumber = Integer.parseInt(pg);
            }
            List<Resource> all = Redirects.readRedirects(configResource);
            this.pages = Lists.partition(all, this.pageSize);
        }
    }

    public static List<Resource> readRedirects(Resource configResource) {
        long t0 = System.currentTimeMillis();
        final ArrayList<Resource> redirects = new ArrayList<Resource>();
        new AbstractResourceVisitor(){

            public void visit(Resource res) {
                if (res.isResourceType("acs-commons/components/utilities/manage-redirects/redirect-row")) {
                    redirects.add(res);
                }
            }
        }.accept(configResource);
        log.debug("Read {} redirects from {} in {}ms", new Object[]{redirects.size(), configResource.getPath(), System.currentTimeMillis() - t0});
        return redirects;
    }

    public List<Resource> getItems() {
        return this.pages.isEmpty() ? Collections.emptyList() : this.pages.get(this.pageNumber - 1);
    }

    public boolean isPaginated() {
        return this.pages.size() > 1;
    }

    public int getPages() {
        return this.pages.size();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public boolean hasNext() {
        return this.pageNumber < this.pages.size();
    }

    public int getNextPage() {
        return this.pageNumber + 1;
    }

    public boolean hasPrevious() {
        return this.pageNumber > 1;
    }

    public int getPreviousPage() {
        return this.pageNumber - 1;
    }

    public String getContextPrefix() {
        return this.contextPrefix;
    }

    public boolean getIgnoreSelectors() {
        return this.ignoreSelectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Resource> search(String term, @NotNull String path) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashMap<String, String> map = new HashMap<String, String>();
        term = "*" + StringUtils.lowerCase((String)term) + "*";
        map.put("type", "nt:unstructured");
        map.put("path", path);
        map.put("1_group.p.or", "true");
        map.put("1_group.1_fulltext.relPath", "@source");
        map.put("1_group.1_fulltext", term);
        map.put("1_group.2_fulltext.relPath", "@target");
        map.put("1_group.2_fulltext", term);
        map.put("1_group.3_fulltext.relPath", "@note");
        map.put("1_group.3_fulltext", term);
        map.put("1_group.4_fulltext.relPath", "@cacheControlHeader");
        map.put("1_group.4_fulltext", term);
        map.put("1_group.f5_ulltext.relPath", "@cq:tags");
        map.put("1_group.5_fulltext", term);
        map.put("1_group.6_fulltext.relPath", "@statusCode");
        map.put("1_group.6_fulltext", term);
        map.put("1_group.7_fulltext.relPath", "@jcr:createdBy");
        map.put("1_group.7_fulltext", term);
        map.put("1_group.8_fulltext.relPath", "@jcr:lastModifiedBy");
        map.put("1_group.8_fulltext", term);
        map.put("property", "sling:resourceType");
        map.put("property.value", "acs-commons/components/utilities/manage-redirects/redirect-row");
        map.put("orderby", "@jcr:score");
        map.put("orderby.sort", "desc");
        map.put("p.offset", "0");
        map.put("p.limit", "100");
        map.put("p.guessTotal", "true");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)this.request.getResourceResolver().adaptTo(Session.class));
        SearchResult result = query.getResult();
        try (ResourceResolver leakingResourceResolver = null;){
            for (Hit hit : result.getHits()) {
                if (leakingResourceResolver == null) {
                    leakingResourceResolver = hit.getResource().getResourceResolver();
                }
                Resource resource = this.request.getResourceResolver().getResource(hit.getPath());
                resources.add(resource);
            }
        }
        return resources;
    }
}

