/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingException;
import com.adobe.acs.commons.mcp.impl.processes.renovator.ReplicatorQueue;
import com.adobe.acs.commons.mcp.impl.processes.renovator.Util;
import com.adobe.acs.commons.util.visitors.SimpleFilteringResourceVisitor;
import com.day.cq.audit.AuditLog;
import com.day.cq.audit.AuditLogEntry;
import com.day.cq.wcm.api.PageModification;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public abstract class MovingNode {
    private String sourcePath;
    private String destinationPath;
    private String previousSibling;
    private MovingNode parent;
    private List<MovingNode> children = new ArrayList<MovingNode>();
    private final List<String> allReferences = new ArrayList<String>();
    private final List<String> publishedReferences = new ArrayList<String>();
    private boolean destinationAlreadyExists;
    private boolean sourceActivated;

    public abstract boolean isCopiedBeforeMove();

    public abstract boolean isSupposedToBeReferenced();

    public abstract boolean isAbleToHaveChildren();

    protected abstract boolean isAuditableMove();

    public void addChild(MovingNode child) {
        if (child != this) {
            this.children.add(child);
            child.setParent(this);
        }
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public boolean isSourceActivated() {
        return this.sourceActivated;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public MovingNode getParent() {
        return this.parent;
    }

    public void setParent(MovingNode parent) {
        this.parent = parent;
        if (parent != null && parent != this) {
            this.setDestinationPath(this.sourcePath.replaceFirst(Pattern.quote(parent.getSourcePath()), parent.getDestinationPath()));
        }
    }

    public List<MovingNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void setChildren(List<MovingNode> children) {
        this.children = Optional.ofNullable(children).map(list -> new ArrayList(list)).orElse(Collections.emptyList());
    }

    public List<String> getAllReferences() {
        return Collections.unmodifiableList(this.allReferences);
    }

    public List<String> getPublishedReferences() {
        return Collections.unmodifiableList(this.publishedReferences);
    }

    public boolean isDestinationAlreadyExists() {
        return this.destinationAlreadyExists;
    }

    public void setDestinationAlreadyExists(boolean destinationAlreadyExists) {
        this.destinationAlreadyExists = destinationAlreadyExists;
    }

    public String getPreviousSibling() {
        return this.previousSibling;
    }

    public abstract void move(ReplicatorQueue var1, ResourceResolver var2) throws IllegalAccessException, MovingException;

    public void findReferences(ResourceResolver rr, String referenceSearchRoot, int maxReferences) throws IllegalAccessException {
        ReferenceSearch refSearch = new ReferenceSearch();
        refSearch.setExact(true);
        refSearch.setHollow(true);
        refSearch.setMaxReferencesPerPage(maxReferences);
        refSearch.setSearchRoot(referenceSearchRoot);
        refSearch.search(rr, this.sourcePath).values().stream().peek(p -> this.allReferences.add(p.getPagePath())).filter(p -> Util.isActivated(rr, p.getPagePath())).map(ReferenceSearch.Info::getPagePath).collect(Collectors.toCollection(() -> this.publishedReferences));
        if (Util.isActivated(rr, this.sourcePath)) {
            this.publishedReferences.add(this.destinationPath);
        }
    }

    public void visit(Consumer<MovingNode> consumer) {
        this.visit(consumer, consumer, null);
    }

    public void visit(Consumer<MovingNode> consumer, Consumer<MovingNode> leafConsumer, Function<MovingNode, Boolean> traversalFilter) {
        LinkedList<MovingNode> stack = new LinkedList<MovingNode>();
        stack.clear();
        stack.add(this);
        while (!stack.isEmpty()) {
            MovingNode node = (MovingNode)stack.poll();
            if (traversalFilter == null || traversalFilter.apply(node).booleanValue()) {
                stack.addAll(SimpleFilteringResourceVisitor.toList(node.getChildren()));
                consumer.accept(node);
                continue;
            }
            if (leafConsumer == null) continue;
            leafConsumer.accept(node);
        }
    }

    public Optional<MovingNode> findByPath(String path) {
        if (path.equals(this.getSourcePath())) {
            return Optional.of(this);
        }
        String[] parts = path.replaceFirst(this.getSourcePath() + "/", "").split("/");
        MovingNode current = this;
        for (String part : parts) {
            String childPath = current.getSourcePath() + "/" + part;
            boolean found = false;
            for (MovingNode child : current.getChildren()) {
                if (!child.getSourcePath().equals(childPath)) continue;
                current = child;
                found = true;
            }
            if (found) continue;
            return Optional.empty();
        }
        return Optional.of(current);
    }

    public boolean hasChild(String path) {
        return this.getChildren().stream().anyMatch(n -> n.getSourcePath().equals(path));
    }

    protected Map<String, Object> getClonedProperties(Resource source) {
        HashMap<String, Object> props = new HashMap<String, Object>((Map<String, Object>)source.getValueMap());
        props.remove("jcr:versionHistory");
        props.remove("jcr:uuid");
        props.remove("jcr:baseVersion");
        props.remove("jcr:predecessors");
        props.remove("jcr:isCheckedOut");
        return props;
    }

    public void addAuditRecordForMove(ResourceResolver rr, AuditLog auditLog) {
        if (this.isAuditableMove()) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("path", this.getSourcePath());
            props.put("destination", this.getDestinationPath());
            props.put("type", PageModification.ModificationType.MOVED.toString());
            AuditLogEntry moveAuditEntry = new AuditLogEntry("com/day/cq/wcm/core/page", Calendar.getInstance().getTime(), rr.getUserID() != null ? rr.getUserID() : "renovator", this.getSourcePath(), PageModification.ModificationType.MOVED.toString(), props);
            auditLog.add(moveAuditEntry);
        }
    }
}

