/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.form.DialogResourceProvider;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.models.annotations.Model;

public class DialogProviderAnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOG = Logger.getLogger(DialogProviderAnnotationProcessor.class.getName());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(DialogProvider.class)) {
            try {
                this.processDialogProviderAnnotation(element);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(DialogProvider.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void processDialogProviderAnnotation(Element element) throws IOException {
        TypeElement t = (TypeElement)element;
        String className = t.getQualifiedName().toString();
        String serviceClassName = DialogProviderAnnotationProcessor.getServiceClassName(className);
        if (this.providesResourceType(t)) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, String.format("Generated resource provider service for class %s => %s", className, serviceClassName));
            }
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(serviceClassName, new Element[0]);
            this.writeServiceStub(builderFile, serviceClassName, className);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, String.format("Class %s declares or inherits the DialogProvider annotation but does not declare a resource type -- no resource provider generated.", className));
        }
    }

    private void writeServiceStub(JavaFileObject builderFile, String serviceClass, String targetClass) throws IOException {
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            String packageName = StringUtils.substringBeforeLast((String)serviceClass, (String)".");
            String className = StringUtils.substringAfterLast((String)serviceClass, (String)".");
            String osgiService = DialogResourceProvider.class.getCanonicalName();
            out.println(String.format("package %s;", packageName));
            out.println();
            out.println("import javax.annotation.Generated;");
            out.println("import org.osgi.annotation.versioning.ConsumerType;");
            out.println("import org.osgi.framework.BundleContext;");
            out.println("import org.osgi.service.component.annotations.*;");
            out.println();
            out.println("@Generated(\"Created by the ACS Commons DialogProviderAnnotationProcessor\")");
            out.println("@ConsumerType");
            out.printf("@Component(service = %s.class, immediate = true)%n", osgiService);
            out.printf("public class %s implements %s {%n", className, osgiService);
            out.println();
            out.println("    @Override");
            out.println("    public Class getTargetClass() {");
            out.printf("        return %s.class;%n", targetClass);
            out.println("    }");
            out.println();
            out.println("    @Activate");
            out.println("    public void activate(BundleContext context) throws InstantiationException, IllegalAccessException, ReflectiveOperationException {");
            out.println("        this.doActivate(context);");
            out.println("    }");
            out.println();
            out.println("    @Deactivate");
            out.println("    public void deactivate(BundleContext context) {");
            out.println("        this.doDeactivate();");
            out.println("    }");
            out.println("}");
            out.flush();
        }
    }

    private boolean providesResourceType(TypeElement t) {
        Model model = t.getAnnotation(Model.class);
        if (model != null && model.resourceType() != null && model.resourceType().length > 0) {
            return true;
        }
        return t.getEnclosedElements().stream().anyMatch(this::elementProvidesResourceType);
    }

    private boolean elementProvidesResourceType(Element t) {
        switch (t.getKind()) {
            case LOCAL_VARIABLE: 
            case FIELD: {
                return t.getSimpleName().contentEquals("resourceType");
            }
            case METHOD: {
                return t.getSimpleName().contentEquals("getResourceType");
            }
        }
        return false;
    }

    private static String getServiceClassName(String modelClass) {
        String[] parts = StringUtils.split((String)modelClass, (char)'.');
        StringBuilder name = new StringBuilder();
        String separator = ".";
        for (String part : parts) {
            char firstChar = part.charAt(0);
            String newSeparator = separator;
            if (firstChar >= 'A' && firstChar <= 'Z' && separator.equals(".")) {
                newSeparator = "$";
                name.append(".impl");
            }
            if (name.length() > 0) {
                name.append(separator);
            }
            name.append(part);
            separator = newSeparator;
        }
        return name + "_dialogResourceProvider";
    }
}

