/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.handler;

import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheKeyHandler;
import java.io.IOException;
import java.time.Clock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;

public class BucketNodeHandler {
    private final Node bucketNode;
    private final DynamicClassLoaderManager dynamicClassLoaderManager;
    private final Clock clock;

    public BucketNodeHandler(Node node, DynamicClassLoaderManager dynamicClassLoaderManager, Clock clock) {
        this.bucketNode = node;
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
        this.clock = clock;
    }

    public Node createOrRetrieveEntryNode(CacheKey key, long engineDefaultExpiryInMs) throws RepositoryException, IOException, ClassNotFoundException {
        Node existingEntryNode = this.getEntryIfExists(key);
        if (null != existingEntryNode) {
            if (key.getExpiryForUpdate() > 0L) {
                existingEntryNode.setProperty("expiresOn", System.currentTimeMillis() + key.getExpiryForUpdate());
            }
            return existingEntryNode;
        }
        Node created = JcrUtils.getOrCreateUniqueByPath((Node)this.bucketNode, (String)"entry", (String)"oak:Unstructured");
        created.setProperty("expiresOn", System.currentTimeMillis() + engineDefaultExpiryInMs);
        return created;
    }

    public Node getEntryIfExists(CacheKey key) throws RepositoryException, IOException, ClassNotFoundException {
        return this.getEntryIfExists(key, false);
    }

    public Node getEntryIfExists(CacheKey key, boolean ignoreExpiration) throws RepositoryException, IOException, ClassNotFoundException {
        NodeIterator entryNodeIterator = this.bucketNode.getNodes();
        while (entryNodeIterator.hasNext()) {
            boolean isExpired;
            Node entryNode = entryNodeIterator.nextNode();
            CacheKey entryKey = new EntryNodeToCacheKeyHandler(entryNode, this.dynamicClassLoaderManager).get();
            boolean bl = isExpired = entryNode.getProperty("expiresOn").getLong() < this.clock.instant().toEpochMilli();
            if (!key.equals(entryKey) || isExpired && !ignoreExpiration) continue;
            return entryNode;
        }
        return null;
    }
}

