/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.caffeine.impl;

import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemCachePersistenceObject;
import com.github.benmanes.caffeine.cache.Expiry;

public class CacheExpiryPolicy
implements Expiry<CacheKey, MemCachePersistenceObject> {
    private final long standardTtl;

    public CacheExpiryPolicy(long standardTtl) {
        this.standardTtl = standardTtl;
    }

    public long expireAfterCreate(CacheKey key, MemCachePersistenceObject value, long currentTime) {
        long customExpiryTime = key.getExpiryForCreation();
        if (customExpiryTime > 0L) {
            return customExpiryTime * 1000000L;
        }
        if (this.standardTtl > 0L) {
            return this.standardTtl * 1000000L;
        }
        return Long.MAX_VALUE;
    }

    public long expireAfterUpdate(CacheKey key, MemCachePersistenceObject value, long currentTime, long currentDuration) {
        if (key.getExpiryForUpdate() > 0L) {
            return key.getExpiryForUpdate() * 1000000L;
        }
        return currentDuration;
    }

    public long expireAfterRead(CacheKey key, MemCachePersistenceObject value, long currentTime, long currentDuration) {
        if (key.getExpiryForAccess() > 0L) {
            return key.getExpiryForAccess() * 1000000L;
        }
        return currentDuration;
    }
}

