/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine.impl;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.engine.HttpCacheServletResponseWrapper;
import com.adobe.acs.commons.httpcache.engine.impl.HttpCacheEngineMBean;
import com.adobe.acs.commons.httpcache.engine.impl.delegate.HttpCacheEngineBindingsDelegate;
import com.adobe.acs.commons.httpcache.engine.impl.delegate.HttpCacheEngineMBeanDelegate;
import com.adobe.acs.commons.httpcache.exception.HttpCacheConfigConflictException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCachePersistenceException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.rule.HttpCacheHandlingRule;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import com.adobe.acs.commons.httpcache.util.CacheUtils;
import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Engine", description="Controlling service for http cache implementation.", metatype=true)
@Properties(value={@Property(name="jmx.objectname", value={"com.adobe.acs.commons.httpcache:type=HTTP Cache - Engine"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"Global handling rules: {httpcache.engine.cache-handling-rules.global}"}, propertyPrivate=true)})
@References(value={@Reference(name="httpCacheConfig", referenceInterface=HttpCacheConfig.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE), @Reference(name="httpCacheHandlingRule", referenceInterface=HttpCacheHandlingRule.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE), @Reference(name="httpCacheStore", referenceInterface=HttpCacheStore.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE)})
@Service(value={DynamicMBean.class, HttpCacheEngine.class})
public class HttpCacheEngineImpl
extends AnnotatedStandardMBean
implements HttpCacheEngine,
HttpCacheEngineMBean {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheEngineImpl.class);
    static final String METHOD_NAME_TO_BIND_CONFIG = "httpCacheConfig";
    static final String METHOD_NAME_TO_BIND_CACHE_STORE = "httpCacheStore";
    static final String METHOD_NAME_TO_BIND_CACHE_HANDLING_RULES = "httpCacheHandlingRule";
    @Property(label="Global HttpCacheHandlingRules", description="List of Service pid of HttpCacheHandlingRule applicable for all cache configs.", unbounded=PropertyUnbounded.ARRAY, value={"com.adobe.acs.commons.httpcache.rule.impl.CacheOnlyGetRequest", "com.adobe.acs.commons.httpcache.rule.impl.CacheOnlyResponse200", "com.adobe.acs.commons.httpcache.rule.impl.HonorCacheControlHeaders", "com.adobe.acs.commons.httpcache.rule.impl.DoNotCacheZeroSizeResponse"})
    static final String PROP_GLOBAL_CACHE_HANDLING_RULES_PID = "httpcache.engine.cache-handling-rules.global";
    private List<String> globalCacheHandlingRulesPid;
    @Property(label="Globally ignored response headers", description="List of header keys (as regex statements) that should NOT be put in the cached response, to be served to the output.", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_GLOBAL_RESPONSE_HEADER_EXCLUSIONS = "httpcache.engine.excluded.response.headers.global";
    private List<Pattern> globalHeaderExclusions;
    @Property(label="Globally ignored cookie keys", description="List of cookie keys of cookies that should NOT be put in the cached response, to be served to the output.", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_GLOBAL_RESPONSE_COOKIE_EXCLUSIONS = "httpcache.engine.excluded.response.cookies.global";
    private List<String> globalCookieExclusions;
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;
    private final HttpCacheEngineMBeanDelegate mBeanDelegate = new HttpCacheEngineMBeanDelegate();
    private final HttpCacheEngineBindingsDelegate bindingsDelegate = new HttpCacheEngineBindingsDelegate();

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.globalCacheHandlingRulesPid = new ArrayList<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_GLOBAL_CACHE_HANDLING_RULES_PID), (String[])new String[0])));
        this.globalHeaderExclusions = ParameterUtil.toPatterns(PropertiesUtil.toStringArray((Object)configs.get(PROP_GLOBAL_RESPONSE_HEADER_EXCLUSIONS), (String[])new String[0]));
        this.globalCookieExclusions = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_GLOBAL_RESPONSE_COOKIE_EXCLUSIONS), (String[])new String[0]));
        ListIterator<String> listIterator = this.globalCacheHandlingRulesPid.listIterator();
        while (listIterator.hasNext()) {
            String value = listIterator.next();
            if (!StringUtils.isBlank((CharSequence)value)) continue;
            listIterator.remove();
        }
        log.info("HttpCacheEngineImpl activated.");
    }

    @Deactivate
    protected void deactivate(Map<String, Object> configs) {
        log.info("HttpCacheEngineImpl deactivated.");
    }

    @Override
    public boolean isRequestCacheable(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheRepositoryAccessException {
        for (Map.Entry<String, HttpCacheHandlingRule> entry : this.bindingsDelegate.getCacheHandlingRules().entrySet()) {
            HttpCacheHandlingRule rule;
            if (!this.globalCacheHandlingRulesPid.contains(entry.getKey()) && !cacheConfig.acceptsRule(entry.getKey()) || (rule = entry.getValue()).onRequestReceive(request)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Request cannot be cached for the url {} honoring the rule {}", (Object)request.getRequestURL(), (Object)rule.getClass().getName());
            }
            return false;
        }
        return true;
    }

    @Override
    public HttpCacheConfig getCacheConfig(SlingHttpServletRequest request) throws HttpCacheRepositoryAccessException, HttpCacheConfigConflictException {
        return this.getCacheConfig(request, HttpCacheConfig.FilterScope.REQUEST);
    }

    @Override
    public HttpCacheConfig getCacheConfig(SlingHttpServletRequest request, HttpCacheConfig.FilterScope filterScope) throws HttpCacheConfigConflictException, HttpCacheRepositoryAccessException {
        HttpCacheConfig bestCacheConfig = null;
        for (HttpCacheConfig cacheConfig : this.bindingsDelegate.getCacheConfigs()) {
            if (bestCacheConfig != null) {
                if (bestCacheConfig.getOrder() == cacheConfig.getOrder()) {
                    if (!cacheConfig.accepts(request)) continue;
                    throw new HttpCacheConfigConflictException();
                }
                if (bestCacheConfig.getOrder() >= cacheConfig.getOrder()) continue;
                break;
            }
            if (!filterScope.equals((Object)cacheConfig.getFilterScope()) || !cacheConfig.accepts(request)) continue;
            bestCacheConfig = cacheConfig;
        }
        if (bestCacheConfig == null && log.isDebugEnabled()) {
            log.debug("Matching cache config not found.");
        }
        return bestCacheConfig;
    }

    @Override
    public boolean isCacheHit(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException, HttpCachePersistenceException {
        return this.getCacheStore(cacheConfig).contains(cacheConfig.buildCacheKey(request));
    }

    @Override
    public boolean deliverCacheContent(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException, HttpCacheDataStreamException, HttpCachePersistenceException {
        CacheContent cacheContent = this.getCacheStore(cacheConfig).getIfPresent(cacheConfig.buildCacheKey(request));
        if (!this.isRequestDeliverableFromCacheAccordingToHandlingRules(request, response, cacheConfig, cacheContent)) {
            return false;
        }
        this.prepareCachedResponse(response, cacheContent);
        return this.executeCacheContentDeliver(request, response, cacheContent);
    }

    @Override
    public HttpCacheServletResponseWrapper wrapResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) throws HttpCacheDataStreamException, HttpCachePersistenceException {
        try {
            return new HttpCacheServletResponseWrapper(response, this.getCacheStore(cacheConfig).createTempSink());
        }
        catch (IOException e) {
            throw new HttpCacheDataStreamException(e);
        }
    }

    @Override
    public void cacheResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) {
        if (!(response instanceof HttpCacheServletResponseWrapper)) {
            throw new AssertionError((Object)"Programming error.");
        }
        HttpCacheServletResponseWrapper responseWrapper = (HttpCacheServletResponseWrapper)response;
        Map<String, List<String>> extractedHeaders = CacheUtils.extractHeaders(this.globalHeaderExclusions, this.globalCookieExclusions, (SlingHttpServletResponse)responseWrapper, cacheConfig);
        int status = responseWrapper.getStatus();
        String charEncoding = responseWrapper.getCharacterEncoding();
        String contentType = responseWrapper.getContentType();
        try {
            CacheKey cacheKey = cacheConfig.buildCacheKey(request);
            CacheContent cacheContent = new CacheContent().build(responseWrapper, status, charEncoding, contentType, extractedHeaders);
            if (this.isRequestCachableAccordingToHandlingRules(request, response, cacheConfig, cacheContent)) {
                this.throttledTaskRunner.scheduleWork(this.putToStore(cacheConfig, cacheKey, cacheContent));
                log.debug("Response for the URI cached - {}", (Object)request.getRequestURI());
            }
        }
        catch (HttpCacheException e) {
            log.error("Error creating http cache content", (Throwable)e);
        }
    }

    @Override
    public boolean isPathPotentialToInvalidate(String path) {
        for (HttpCacheConfig config : this.bindingsDelegate.getCacheConfigs()) {
            if (!config.canInvalidate(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invalidateCache(String path) throws HttpCachePersistenceException, HttpCacheKeyCreationException {
        for (HttpCacheConfig cacheConfig : this.bindingsDelegate.getCacheConfigs()) {
            if (!cacheConfig.canInvalidate(path)) continue;
            this.executeCustomRuleInvalidations(path, cacheConfig);
        }
    }

    private Runnable putToStore(HttpCacheConfig cacheConfig, CacheKey cacheKey, CacheContent cacheContent) {
        return () -> {
            try {
                this.getCacheStore(cacheConfig).put(cacheKey, cacheContent);
            }
            catch (HttpCacheException e) {
                log.error("Error storing http response in httpcache", (Throwable)e);
            }
            finally {
                if (null != cacheContent) {
                    IOUtils.closeQuietly((InputStream)cacheContent.getInputDataStream());
                }
            }
        };
    }

    private HttpCacheStore getCacheStore(HttpCacheConfig cacheConfig) throws HttpCachePersistenceException {
        if (this.bindingsDelegate.getCacheStoresMap().containsKey(cacheConfig.getCacheStoreName())) {
            return this.bindingsDelegate.getCacheStoresMap().get(cacheConfig.getCacheStoreName());
        }
        throw new HttpCachePersistenceException("Configured cache store unavailable " + cacheConfig.getCacheStoreName());
    }

    public HttpCacheEngineImpl() throws NotCompliantMBeanException {
        super(HttpCacheEngineMBean.class);
    }

    @Override
    public TabularData getRegisteredHttpCacheRules() throws OpenDataException {
        return this.mBeanDelegate.getRegisteredHttpCacheRules(this.bindingsDelegate.getCacheHandlingRules());
    }

    @Override
    public TabularData getRegisteredHttpCacheConfigs() throws OpenDataException {
        return this.mBeanDelegate.getRegisteredHttpCacheConfigs(this.bindingsDelegate.getCacheConfigs(), this.bindingsDelegate.getCacheConfigConfigs());
    }

    @Override
    public TabularData getRegisteredPersistenceStores() throws OpenDataException {
        return this.mBeanDelegate.getRegisteredPersistenceStores(this.bindingsDelegate.getCacheStoresMap());
    }

    protected void bindHttpCacheConfig(HttpCacheConfig cacheConfig, Map<String, Object> configs) {
        this.bindingsDelegate.bindHttpCacheConfig(cacheConfig, configs);
    }

    protected void unbindHttpCacheConfig(HttpCacheConfig cacheConfig, Map<String, Object> config) {
        this.bindingsDelegate.unbindHttpCacheConfig(cacheConfig);
    }

    protected void bindHttpCacheStore(HttpCacheStore cacheStore) {
        this.bindingsDelegate.bindHttpCacheStore(cacheStore);
    }

    protected void unbindHttpCacheStore(HttpCacheStore cacheStore) {
        this.bindingsDelegate.unbindHttpCacheStore(cacheStore);
    }

    protected void bindHttpCacheHandlingRule(HttpCacheHandlingRule cacheHandlingRule, Map<String, Object> properties) {
        this.bindingsDelegate.bindHttpCacheHandlingRule(cacheHandlingRule, properties);
    }

    protected void unbindHttpCacheHandlingRule(HttpCacheHandlingRule cacheHandlingRule, Map<String, Object> configs) {
        this.bindingsDelegate.unbindHttpCacheHandlingRule(cacheHandlingRule, configs);
    }

    private boolean isRequestCachableAccordingToHandlingRules(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig, CacheContent cacheContent) {
        return this.checkOnHandlingRule(request, cacheConfig, rule -> rule.onResponseCache(request, response, cacheConfig, cacheContent), "Caching for request {} has been cancelled as per custom rule {}");
    }

    private boolean isRequestDeliverableFromCacheAccordingToHandlingRules(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig, CacheContent cacheContent) {
        return this.checkOnHandlingRule(request, cacheConfig, rule -> rule.onCacheDeliver(request, response, cacheConfig, cacheContent), "Cache cannot be delivered for the url {} honoring the rule {}");
    }

    private boolean checkOnHandlingRule(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, Function<HttpCacheHandlingRule, Boolean> check, String onFailLogMessage) {
        for (Map.Entry<String, HttpCacheHandlingRule> entry : this.bindingsDelegate.getCacheHandlingRules().entrySet()) {
            HttpCacheHandlingRule rule;
            if (!this.globalCacheHandlingRulesPid.contains(entry.getKey()) && !cacheConfig.acceptsRule(entry.getKey()) || check.apply(rule = entry.getValue()).booleanValue()) continue;
            if (log.isDebugEnabled()) {
                log.debug(onFailLogMessage, (Object)request.getRequestURL(), (Object)rule.getClass().getName());
            }
            return false;
        }
        return true;
    }

    private void prepareCachedResponse(SlingHttpServletResponse response, CacheContent cacheContent) {
        response.setStatus(cacheContent.getStatus());
        for (String headerName : cacheContent.getHeaders().keySet()) {
            for (String headerValue : cacheContent.getHeaders().get(headerName)) {
                response.setHeader(headerName, headerValue);
            }
        }
        response.setContentType(cacheContent.getContentType());
        response.setCharacterEncoding(cacheContent.getCharEncoding());
    }

    private boolean executeCacheContentDeliver(SlingHttpServletRequest request, SlingHttpServletResponse response, CacheContent cacheContent) throws HttpCacheDataStreamException {
        try {
            this.serveCacheContentIntoResponse(response, cacheContent);
            if (log.isDebugEnabled()) {
                log.debug("Response delivered from cache for the url [ {} ]", (Object)request.getRequestURI());
            }
            return true;
        }
        catch (IOException e) {
            throw new HttpCacheDataStreamException("Unable to copy from cached data to the servlet output stream.");
        }
    }

    private void serveCacheContentIntoResponse(SlingHttpServletResponse response, CacheContent cacheContent) throws IOException {
        if (HttpCacheServletResponseWrapper.ResponseWriteMethod.OUTPUTSTREAM.equals((Object)cacheContent.getWriteMethod())) {
            try {
                IOUtils.copy((InputStream)cacheContent.getInputDataStream(), (OutputStream)response.getOutputStream());
            }
            catch (IllegalStateException ex) {
                IOUtils.copy((InputStream)cacheContent.getInputDataStream(), (Writer)response.getWriter(), (String)response.getCharacterEncoding());
            }
        } else {
            IOUtils.copy((InputStream)cacheContent.getInputDataStream(), (Writer)response.getWriter(), (String)response.getCharacterEncoding());
        }
    }

    private void executeCustomRuleInvalidations(String path, HttpCacheConfig cacheConfig) throws HttpCachePersistenceException, HttpCacheKeyCreationException {
        for (Map.Entry<String, HttpCacheHandlingRule> entry : this.bindingsDelegate.getCacheHandlingRules().entrySet()) {
            if (!this.globalCacheHandlingRulesPid.contains(entry.getKey()) && !cacheConfig.acceptsRule(entry.getKey())) continue;
            HttpCacheHandlingRule rule = entry.getValue();
            if (rule.onCacheInvalidate(path)) {
                this.getCacheStore(cacheConfig).invalidate(cacheConfig.buildCacheKey(path));
                continue;
            }
            log.debug("Cache invalidation rejected for path {} per custom rule {}", (Object)path, (Object)rule.getClass().getName());
        }
    }

    protected void bindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.throttledTaskRunner = throttledTaskRunner;
    }

    protected void unbindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.throttledTaskRunner == throttledTaskRunner) {
            this.throttledTaskRunner = null;
        }
    }
}

