/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl.keys;

import acscommons.com.google.common.collect.ImmutableMap;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.keys.AbstractCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.sling.api.SlingHttpServletRequest;

public class KeyValueCacheKey
extends AbstractCacheKey
implements CacheKey,
Serializable {
    private String cacheKeyId;
    private ImmutableMap<String, String> actualKeyValues;
    private ImmutableMap<String, String[]> allowedKeyValues;

    public KeyValueCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, String cacheKeyId, Map<String, String[]> allowedKeyValues, Map<String, String> actualKeyValues) {
        super(request, cacheConfig);
        this.cacheKeyId = cacheKeyId;
        this.allowedKeyValues = ImmutableMap.copyOf(allowedKeyValues);
        this.actualKeyValues = ImmutableMap.copyOf(actualKeyValues);
    }

    public KeyValueCacheKey(String uri, HttpCacheConfig cacheConfig, String cacheKeyId, Map<String, String[]> allowedKeyValues) {
        super(uri, cacheConfig);
        this.cacheKeyId = cacheKeyId;
        this.allowedKeyValues = ImmutableMap.copyOf(allowedKeyValues);
        this.actualKeyValues = ImmutableMap.copyOf(Collections.emptyMap());
    }

    Map<String, String> getActualKeyValues() {
        return this.actualKeyValues;
    }

    Map<String, String[]> getAllowedKeyValues() {
        return this.allowedKeyValues;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyValueCacheKey that = (KeyValueCacheKey)o;
        if (that == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getUri(), (Object)that.getUri()).append((Object)this.cacheKeyId, (Object)that.cacheKeyId).append((Object)this.getAuthenticationRequirement(), (Object)that.getAuthenticationRequirement()).appendSuper(this.getEqualForAllowedKeyValues(that)).isEquals();
    }

    private boolean getEqualForAllowedKeyValues(KeyValueCacheKey other) {
        Object val;
        String key;
        if (this.allowedKeyValues.size() != other.allowedKeyValues.size()) {
            return false;
        }
        for (Map.Entry entry : this.allowedKeyValues.entrySet()) {
            key = (String)entry.getKey();
            val = (String[])entry.getValue();
            if (other.allowedKeyValues.containsKey(key) && Arrays.equals((Object[])val, other.allowedKeyValues.get(key))) continue;
            return false;
        }
        if (this.actualKeyValues.size() != other.actualKeyValues.size()) {
            return false;
        }
        for (Map.Entry entry : this.actualKeyValues.entrySet()) {
            key = (String)entry.getKey();
            val = (String)entry.getValue();
            if (other.getActualKeyValues().containsKey(key) && ((String)val).equals(other.getActualKeyValues().get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUri()).append((Object)this.cacheKeyId).append((Object)this.getAuthenticationRequirement()).toHashCode();
    }

    @Override
    public String toString() {
        if (this.actualKeyValues != null) {
            return String.format("%s%s%s", this.resourcePath, this.cacheKeyId, this.getKeyValueToStringRepresentation());
        }
        return String.format("%s%s", this.resourcePath, this.cacheKeyId);
    }

    private String getKeyValueToStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.allowedKeyValues.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            sb.append(key);
            if (this.actualKeyValues != null && StringUtils.isNotBlank((CharSequence)(value = this.actualKeyValues.get(key)))) {
                sb.append("=" + value);
            }
            sb.append(";");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        this.parentWriteObject(o);
        o.writeUTF(this.cacheKeyId);
        o.writeObject(new HashMap<String, String[]>(this.allowedKeyValues));
        o.writeObject(new HashMap<String, String>(this.actualKeyValues));
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        this.parentReadObject(o);
        this.cacheKeyId = o.readUTF();
        this.allowedKeyValues = ImmutableMap.copyOf((Map)o.readObject());
        this.actualKeyValues = ImmutableMap.copyOf((Map)o.readObject());
    }
}

