/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import com.adobe.acs.commons.util.TypeUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class NamespaceDecoratedValueMapBuilder {
    public static final String REQ_ATTR_TEST_FLAG = "ACS_COMMONS_TEST_FLAG";
    private final SlingHttpServletRequest request;
    private final Map<String, Object> copyMap;
    private final String[] namespacedProperties;
    static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{\\{(?:\\(([a-zA-Z]+)\\))?([a-zA-Z0-9]+)(:(.*?))?\\}\\}");

    public NamespaceDecoratedValueMapBuilder(SlingHttpServletRequest request, Resource resource, String[] namespacedProperties, boolean copyToplevelProperties) {
        this.request = request;
        this.copyMap = new HashMap<String, Object>();
        if (copyToplevelProperties && request.getResourceResolver().isResourceType(resource, "acs-commons/granite/ui/components/include")) {
            this.preloadPropsOnRootLevel(request, resource);
        }
        this.copyMap.putAll((Map<String, Object>)resource.getValueMap());
        this.namespacedProperties = Optional.ofNullable(namespacedProperties).map(array -> Arrays.copyOf(array, ((String[])array).length)).orElse(new String[0]);
        this.applyDynamicVariables();
        this.applyNameSpacing();
    }

    private void preloadPropsOnRootLevel(SlingHttpServletRequest request, Resource resource) {
        Resource snippetResource;
        String path = (String)resource.getValueMap().get("path", (Object)"");
        if (StringUtils.isNotBlank((CharSequence)path) && (snippetResource = request.getResourceResolver().getResource(path)) != null) {
            ValueMap inclProps = snippetResource.getValueMap();
            this.copyMap.putAll((Map<String, Object>)inclProps);
            if (inclProps.containsKey((Object)"sling:resourceType")) {
                this.copyMap.put("resourceType", inclProps.get((Object)"sling:resourceType"));
            }
        }
    }

    private boolean isResourceType(String resourceType) {
        if (this.request.getAttribute(REQ_ATTR_TEST_FLAG) != null && resourceType.equals(this.copyMap.get("sling:resourceType"))) {
            return true;
        }
        return this.request.getResourceResolver().isResourceType(this.request.getResource(), this.request.getAttribute("ACS_AEM_COMMONS_EXCLUDE_CHILDREN_RESOURCE_TYPE").toString());
    }

    private void applyNameSpacing() {
        Supplier<Boolean> shouldConsiderNamespacing = () -> this.request.getAttribute("ACS_AEM_COMMONS_INCLUDE_NAMESPACE") != null && (this.request.getAttribute("ACS_AEM_COMMONS_EXCLUDE_CHILDREN_RESOURCE_TYPE") == null || this.isResourceType(this.request.getAttribute("ACS_AEM_COMMONS_EXCLUDE_CHILDREN_RESOURCE_TYPE").toString()));
        if (shouldConsiderNamespacing.get().booleanValue()) {
            for (String namespacedProp : this.namespacedProperties) {
                String adjusted;
                if (!this.copyMap.containsKey(namespacedProp)) continue;
                String originalValue = this.copyMap.get(namespacedProp).toString();
                String namespace = this.request.getAttribute("ACS_AEM_COMMONS_INCLUDE_NAMESPACE").toString();
                boolean containsDotSlash = StringUtils.contains((CharSequence)originalValue, (CharSequence)"./");
                if (containsDotSlash) {
                    String extracted = StringUtils.substringAfter((String)originalValue, (String)"./");
                    adjusted = "./" + namespace + "/" + extracted;
                } else {
                    adjusted = namespace + "/" + originalValue;
                }
                this.copyMap.put(namespacedProp, adjusted);
            }
        }
    }

    public ValueMap build() {
        return new ValueMapDecorator(this.copyMap);
    }

    private void applyDynamicVariables() {
        for (Map.Entry<String, Object> entry : this.copyMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            Object filtered = this.filter(entry.getValue().toString(), this.request);
            this.copyMap.put(entry.getKey(), filtered);
        }
    }

    private Object filter(String value, SlingHttpServletRequest request) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String typeHint = matcher.group(1);
            String paramKey = matcher.group(2);
            String defaultValue = matcher.group(4);
            String requestParamValue = request.getAttribute("ACS_AEM_COMMONS_INCLUDE_PREFIX_" + paramKey) != null ? request.getAttribute("ACS_AEM_COMMONS_INCLUDE_PREFIX_" + paramKey).toString() : null;
            String chosenValue = StringUtils.defaultString(requestParamValue, (String)defaultValue);
            String string = replacement = StringUtils.isNotEmpty((CharSequence)typeHint) ? this.castTypeHintedValue(typeHint, chosenValue).toString() : chosenValue;
            if (replacement == null) {
                replacement = "";
            }
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private Object castTypeHintedValue(String typeHint, String chosenValue) {
        Class clazz;
        switch (typeHint.toLowerCase()) {
            case "boolean": {
                clazz = Boolean.class;
                break;
            }
            case "long": {
                clazz = Long.class;
                break;
            }
            case "double": {
                clazz = Double.class;
                break;
            }
            default: {
                clazz = String.class;
            }
        }
        return TypeUtil.toObjectType(chosenValue, clazz);
    }
}

