/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.CancelHandler;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedRunnable
implements Runnable,
Comparable<TimedRunnable> {
    private static AtomicLong taskCounter = new AtomicLong();
    private Long createOrder = taskCounter.getAndAdd(1L);
    long created = System.currentTimeMillis();
    long started = -1L;
    long executed = -1L;
    long finished = -1L;
    int priority;
    Runnable work;
    ThrottledTaskRunner runner;
    Long timeout;
    TimeUnit timeoutUnit;
    Optional<CancelHandler> cancelHandler = Optional.empty();
    private static final Logger LOG = LoggerFactory.getLogger(TimedRunnable.class);

    public TimedRunnable(Runnable work, ThrottledTaskRunner runner, long timeout, TimeUnit timeoutUnit, int priority) {
        this.work = work;
        this.runner = runner;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.priority = priority;
        LOG.debug("Task created");
    }

    public TimedRunnable(Runnable work, ThrottledTaskRunner runner, long timeout, TimeUnit timeoutUnit, CancelHandler cancelHandler, int priority) {
        this(work, runner, timeout, timeoutUnit, priority);
        this.cancelHandler = Optional.of(cancelHandler);
    }

    @Override
    public void run() {
        if (this.cancelHandler.isPresent() && this.cancelHandler.get().isCancelled()) {
            return;
        }
        Thread thisThread = Thread.currentThread();
        Semaphore timerSemaphore = new Semaphore(0);
        Thread watchDog = new Thread(this.watchThread(thisThread, timerSemaphore));
        boolean successful = false;
        Throwable error = null;
        try {
            this.started = System.currentTimeMillis();
            this.runner.waitForLowCpuAndLowMemory();
            this.executed = System.currentTimeMillis();
            if (this.timeout > 0L) {
                watchDog.start();
            }
            this.cancelHandler.ifPresent(h -> h.trackActiveWork(thisThread));
            this.work.run();
            this.finished = System.currentTimeMillis();
            this.cancelHandler.ifPresent(h -> h.untrackActiveWork(thisThread));
            timerSemaphore.release();
            successful = true;
        }
        catch (Throwable ex) {
            this.finished = System.currentTimeMillis();
            this.cancelHandler.ifPresent(h -> h.untrackActiveWork(thisThread));
            LOG.error("Task encountered an uncaught exception", ex);
        }
        this.runner.logCompletion(this.created, this.started, this.executed, this.finished, successful, error);
    }

    private Runnable watchThread(Thread workThread, Semaphore timerSemaphore) {
        return () -> {
            boolean finished1 = false;
            try {
                finished1 = timerSemaphore.tryAcquire(this.timeout, this.timeoutUnit);
            }
            catch (InterruptedException ex) {
                LOG.error("Watchdog thread interrupted", (Throwable)ex);
            }
            if (!finished1) {
                LOG.warn("Thread interruption is no longer supported.");
            }
        };
    }

    @Override
    public int compareTo(TimedRunnable other) {
        int compareResult = Integer.compare(other.priority, this.priority);
        if (compareResult == 0) {
            compareResult = this.createOrder.compareTo(other.createOrder);
        }
        return compareResult;
    }
}

