/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.exporters.impl.tags;

import com.adobe.acs.commons.exporters.impl.tags.Parameters;
import com.adobe.acs.commons.exporters.impl.tags.TagsExportService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.label=ACS AEM Commons - Tags to CSV - Export Servlet", "sling.servlet.methods=GET", "sling.servlet.resourceTypes=acs-commons/components/utilities/exporters/tags-to-csv", "sling.servlet.selectors=export", "sling.servlet.extensions=csv"})
public class TagsExportServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TagsExportServlet.class);
    @Reference
    private transient TagsExportService tagsExportService;

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        ResourceResolver rr = request.getResourceResolver();
        Parameters params = new Parameters(request);
        if (params.containsPath()) {
            response.setContentType("text/csv");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            if (params.isLocalized().booleanValue()) {
                ((Writer)writer).write(this.tagsExportService.exportLocalizedTagsForPath(params.getPath(), rr, params.getDefaultLocalization()));
            } else {
                ((Writer)writer).write(this.tagsExportService.exportNonLocalizedTagsForPath(params.getPath(), rr));
            }
        } else {
            log.warn("Cannot generate tag CSV file, missing 'path' parameter in request.");
        }
    }
}

