/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.errorpagehandler.cache.impl;

import com.adobe.acs.commons.errorpagehandler.cache.impl.CacheEntry;
import com.adobe.acs.commons.errorpagehandler.cache.impl.ErrorPageCache;
import com.adobe.acs.commons.errorpagehandler.cache.impl.ErrorPageCacheMBean;
import com.adobe.acs.commons.util.ResourceDataUtil;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorPageCacheImpl
extends AnnotatedStandardMBean
implements ErrorPageCache,
ErrorPageCacheMBean {
    private static final Logger log = LoggerFactory.getLogger(ErrorPageCacheImpl.class);
    private static final int KB_IN_BYTES = 1000;
    private final ConcurrentMap<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final int ttl;
    private final boolean serveAuthenticatedFromCache;

    public ErrorPageCacheImpl(int ttl, boolean serveAuthenticatedFromCache) throws NotCompliantMBeanException {
        super(ErrorPageCacheMBean.class);
        this.ttl = ttl;
        this.serveAuthenticatedFromCache = serveAuthenticatedFromCache;
        log.info("Starting ACS AEM Commons Error Page Handler Cache");
        log.info(" > TTL (in seconds): {}", (Object)ttl);
        log.info(" > Serve authenticated requests from cache: {}", (Object)serveAuthenticatedFromCache);
    }

    @Override
    public String get(String path, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        boolean newEntry;
        if (!this.serveAuthenticatedFromCache && !this.isAnonymousRequest(request)) {
            return this.getIncludeAsString(path, request, response);
        }
        long start = System.currentTimeMillis();
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(path);
        boolean bl = newEntry = cacheEntry == null;
        if (newEntry || cacheEntry.isExpired(new Date())) {
            String data = this.getIncludeAsString(path, request, response);
            if (data == null) {
                log.debug("Error page representation to cache is null. Setting to empty string.");
                data = "";
            }
            if (newEntry) {
                cacheEntry = new CacheEntry();
            }
            cacheEntry.setData(data);
            cacheEntry.setExpiresIn(this.ttl);
            cacheEntry.incrementMisses();
            if (newEntry) {
                this.cache.put(path, cacheEntry);
            }
            if (log.isDebugEnabled()) {
                long time = System.currentTimeMillis() - start;
                log.debug("Served cache MISS for [ {} ] in [ {} ] ms", (Object)path, (Object)time);
            }
            return data;
        }
        String data = cacheEntry.getData();
        cacheEntry.incrementHits();
        this.cache.put(path, cacheEntry);
        if (log.isDebugEnabled()) {
            long time = System.currentTimeMillis() - start;
            log.debug("Served cache HIT for [ {} ] in [ {} ] ms", (Object)path, (Object)time);
        }
        return data;
    }

    private boolean isAnonymousRequest(SlingHttpServletRequest request) {
        return request.getAuthType() == null || request.getRemoteUser() == null;
    }

    @Override
    public final int getTtlInSeconds() {
        return this.ttl;
    }

    @Override
    public final int getTotalHits() {
        int hits = 0;
        for (CacheEntry entry : this.cache.values()) {
            hits += entry.getHits();
        }
        return hits;
    }

    @Override
    public final int getCacheEntriesCount() {
        return this.cache.size();
    }

    @Override
    public final int getTotalMisses() {
        int misses = 0;
        for (Map.Entry entry : this.cache.entrySet()) {
            misses += ((CacheEntry)entry.getValue()).getMisses();
        }
        return misses;
    }

    @Override
    public final int getTotalCacheRequests() {
        return this.getTotalHits() + this.getTotalMisses();
    }

    @Override
    public final long getCacheSizeInKB() {
        long bytes = 0L;
        for (CacheEntry entry : this.cache.values()) {
            bytes += (long)entry.getBytes();
        }
        return bytes / 1000L;
    }

    @Override
    public final TabularData getCacheEntries() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType("cacheEntry", "Cache Entry", new String[]{"errorPage", "hit", "miss", "hitRate", "missRate", "sizeInKB"}, new String[]{"Error Page", "Hit", "Miss", "Hit Rate", "Miss Rate", "Size in KB"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.FLOAT, SimpleType.FLOAT, SimpleType.INTEGER});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("cacheEntries", "Cache Entries", cacheEntryType, new String[]{"errorPage"}));
        for (Map.Entry entry : this.cache.entrySet()) {
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("errorPage", entry.getKey());
            data.put("hit", cacheEntry.getHits());
            data.put("miss", cacheEntry.getMisses());
            data.put("hitRate", Float.valueOf(cacheEntry.getHitRate()));
            data.put("missRate", Float.valueOf(cacheEntry.getMissRate()));
            data.put("sizeInKB", cacheEntry.getBytes() / 1000);
            tabularData.put(new CompositeDataSupport(cacheEntryType, data));
        }
        return tabularData;
    }

    @Override
    public final void clearCache() {
        this.cache.clear();
    }

    @Override
    public final String getCacheData(String errorPage) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(StringUtils.trim((String)errorPage));
        if (cacheEntry == null) {
            return "";
        }
        return cacheEntry.getData();
    }

    public String getIncludeAsString(String path, SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse) {
        return ResourceDataUtil.getIncludeAsString(path, slingRequest, slingResponse);
    }
}

