/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RenditionPatternPicker
implements RenditionPicker {
    private final Pattern pattern;

    public RenditionPatternPicker(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public RenditionPatternPicker(Pattern pattern) {
        this.pattern = pattern;
    }

    private Pattern getPattern() {
        return this.pattern;
    }

    public final Rendition getRendition(Asset asset) {
        List renditions = asset.getRenditions();
        Pattern p = this.getPattern();
        boolean hasOriginal = asset.getOriginal() != null;
        boolean hasRenditions = renditions.size() > 0;
        for (Rendition rendition : renditions) {
            Matcher m = p.matcher(rendition.getName());
            if (!m.find()) continue;
            return rendition;
        }
        if (hasOriginal) {
            return asset.getOriginal();
        }
        if (hasRenditions) {
            return (Rendition)renditions.get(0);
        }
        return null;
    }
}

