/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.logging.impl;

import com.adobe.acs.commons.util.RequireAem;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, label="ACS AEM Commons - JSON Event Logger", description="Logs OSGi Events for any set of topics to an SLF4j Logger Category, as JSON objects.")
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Logger: {event.logger.category} for events matching '{event.filter}' on '{event.topics}'"})})
public class JsonEventLogger
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonEventLogger.class);
    private static final String PROP_TIMESTAMP = "_timestamp";
    private static final String DEFAULT_LEVEL = "INFO";
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Property(label="Event Topics", unbounded=PropertyUnbounded.ARRAY, description="This value lists the topics handled by this logger. The value is a list of strings. If the string ends with a star, all topics in this package and all subpackages match. If the string does not end with a star, this is assumed to define an exact topic.")
    static final String OSGI_TOPICS = "event.topics";
    @Property(label="Event Filter", description="LDAP-style event filter query. Leave blank to log all events to the configured topic or topics.")
    static final String OSGI_FILTER = "event.filter";
    @Property(label="Logger Name", description="The Sling SLF4j Logger Name or Category to send the JSON messages to. Leave empty to disable the logger.")
    static final String OSGI_CATEGORY = "event.logger.category";
    @Property(label="Logger Level", value={"INFO"}, options={@PropertyOption(name="TRACE", value="Trace"), @PropertyOption(name="DEBUG", value="Debug"), @PropertyOption(name="INFO", value="Information"), @PropertyOption(name="WARN", value="Warnings"), @PropertyOption(name="ERROR", value="Error")}, description="Select the logging level the messages should be sent with.")
    static final String OSGI_LEVEL = "event.logger.level";
    private String[] topics;
    private String filter;
    private String category;
    private String level;
    private Logger eventLogger;
    private Consumer<String> logMapper = JsonEventLogger.logMapperForLevel(null, null);
    private Supplier<Boolean> logEnabler = JsonEventLogger.logEnablerForLevel(null, null);

    static Consumer<String> logMapperForLevel(LogLevel logLevel, Logger logger) {
        if (logger == null) {
            return message -> {};
        }
        switch (logLevel) {
            case ERROR: {
                return arg_0 -> ((Logger)logger).error(arg_0);
            }
            case WARN: {
                return arg_0 -> ((Logger)logger).warn(arg_0);
            }
            case INFO: {
                return arg_0 -> ((Logger)logger).info(arg_0);
            }
            case DEBUG: {
                return arg_0 -> ((Logger)logger).debug(arg_0);
            }
            case TRACE: {
                return arg_0 -> ((Logger)logger).trace(arg_0);
            }
        }
        return message -> {};
    }

    static Supplier<Boolean> logEnablerForLevel(LogLevel logLevel, Logger logger) {
        if (logger == null) {
            return () -> false;
        }
        switch (logLevel) {
            case ERROR: {
                return () -> ((Logger)logger).isErrorEnabled();
            }
            case WARN: {
                return () -> ((Logger)logger).isWarnEnabled();
            }
            case INFO: {
                return () -> ((Logger)logger).isInfoEnabled();
            }
            case DEBUG: {
                return () -> ((Logger)logger).isDebugEnabled();
            }
            case TRACE: {
                return () -> ((Logger)logger).isTraceEnabled();
            }
        }
        return () -> false;
    }

    protected static String constructMessage(Event event) {
        LinkedHashMap<String, Object> eventProperties = new LinkedHashMap<String, Object>();
        String[] stringArray = event.getPropertyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String prop;
            Object val = event.getProperty(prop = stringArray[i]);
            Object converted = JsonEventLogger.convertValue(val);
            eventProperties.put(prop, converted == null ? val : converted);
        }
        eventProperties.put(PROP_TIMESTAMP, ISO8601.format((Calendar)Calendar.getInstance()));
        Gson gson = new Gson();
        return gson.toJson(eventProperties);
    }

    protected static Object convertValue(Object val) {
        if (val instanceof Calendar) {
            return ISO8601.format((Calendar)((Calendar)val));
        }
        if (val instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)val);
            return ISO8601.format((Calendar)calendar);
        }
        return val;
    }

    public void handleEvent(Event event) {
        if (event.getProperty("event.application") == null && this.logEnabler.get().booleanValue()) {
            this.logMapper.accept(JsonEventLogger.constructMessage(event));
        }
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        log.trace("[activate] entered activate method.");
        this.topics = PropertiesUtil.toStringArray((Object)config.get(OSGI_TOPICS));
        this.filter = PropertiesUtil.toString((Object)config.get(OSGI_FILTER), (String)"").trim();
        this.category = PropertiesUtil.toString((Object)config.get(OSGI_CATEGORY), (String)"").trim();
        this.level = PropertiesUtil.toString((Object)config.get(OSGI_LEVEL), (String)DEFAULT_LEVEL);
        if (StringUtils.isNotEmpty((CharSequence)this.category)) {
            this.eventLogger = LoggerFactory.getLogger((String)this.category);
        } else {
            log.warn("No event.logger.category specified. No events will be logged.");
        }
        LogLevel logLevel = LogLevel.fromProperty(this.level);
        this.logEnabler = JsonEventLogger.logEnablerForLevel(logLevel, this.eventLogger);
        this.logMapper = JsonEventLogger.logMapperForLevel(logLevel, this.eventLogger);
        log.trace("[activate] logger state: {}", (Object)this);
    }

    @Deactivate
    protected void deactivate() {
        log.trace("[deactivate] entered deactivate method.");
        this.logEnabler = JsonEventLogger.logEnablerForLevel(LogLevel.NONE, this.eventLogger);
        this.logMapper = JsonEventLogger.logMapperForLevel(LogLevel.NONE, this.eventLogger);
        this.eventLogger = null;
    }

    public String toString() {
        return "JsonEventLogger{topics=" + Arrays.toString(this.topics) + ", filter='" + this.filter + '\'' + ", category='" + this.category + '\'' + ", level='" + this.level + '\'' + ", enabled=" + this.logEnabler.get() + '}';
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        NONE;


        public static LogLevel fromProperty(String prop) {
            if (prop != null) {
                for (LogLevel value : LogLevel.values()) {
                    if (!value.name().equalsIgnoreCase(prop)) continue;
                    return value;
                }
            }
            return NONE;
        }
    }
}

