/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.filter.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.filter.impl.AbstractHttpCacheFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingFilter(generateComponent=true, generateService=true, order=0, scope={SlingFilterScope.INCLUDE})
public class HttpCacheIncludeFilter
extends AbstractHttpCacheFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheIncludeFilter.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private HttpCacheEngine cacheEngine;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, target="(httpcache.config.filter-scope=INCLUDE)")
    private HttpCacheConfig inludeScopeCacheConfigs;

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.trace("In HttpCache Include filter.");
        this.doFilter(request, response, chain, this.cacheEngine, HttpCacheConfig.FilterScope.INCLUDE);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    protected void bindCacheEngine(HttpCacheEngine httpCacheEngine) {
        this.cacheEngine = httpCacheEngine;
    }

    protected void unbindCacheEngine(HttpCacheEngine httpCacheEngine) {
        if (this.cacheEngine == httpCacheEngine) {
            this.cacheEngine = null;
        }
    }

    protected void bindInludeScopeCacheConfigs(HttpCacheConfig httpCacheConfig) {
        this.inludeScopeCacheConfigs = httpCacheConfig;
    }

    protected void unbindInludeScopeCacheConfigs(HttpCacheConfig httpCacheConfig) {
        if (this.inludeScopeCacheConfigs == httpCacheConfig) {
            this.inludeScopeCacheConfigs = null;
        }
    }
}

