/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import com.day.cq.wcm.api.AuthoringUIMode;
import com.day.cq.wcm.api.WCMMode;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.cm.ConfigurationException;

@ProviderType
@Component(immediate=true)
public final class ModeUtil {
    private static boolean isAuthor = false;
    private static boolean isPublish = false;
    private static Set<String> runmodes = new HashSet<String>();

    public static WCMMode getMode(SlingHttpServletRequest req) {
        if (req.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME) == null) {
            return WCMMode.DISABLED;
        }
        String mode = String.valueOf(req.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
        try {
            return WCMMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException ex) {
            return WCMMode.DISABLED;
        }
    }

    public static boolean isAuthor() {
        return isAuthor;
    }

    public static boolean isPublish() {
        return isPublish;
    }

    public static boolean isRunmode(String mode) {
        return runmodes.contains(mode);
    }

    public static boolean isAnalytics(SlingHttpServletRequest request) {
        return WCMMode.ANALYTICS == ModeUtil.getMode(request);
    }

    public static boolean isDesign(SlingHttpServletRequest request) {
        return WCMMode.DESIGN == ModeUtil.getMode(request);
    }

    public static boolean isDisabled(SlingHttpServletRequest request) {
        return WCMMode.DISABLED == ModeUtil.getMode(request);
    }

    public static boolean isEdit(SlingHttpServletRequest request) {
        return WCMMode.EDIT == ModeUtil.getMode(request);
    }

    public static boolean isPreview(SlingHttpServletRequest request) {
        return WCMMode.PREVIEW == ModeUtil.getMode(request);
    }

    public static boolean isReadOnly(SlingHttpServletRequest request) {
        return WCMMode.READ_ONLY == ModeUtil.getMode(request);
    }

    public static boolean isClassic(SlingHttpServletRequest request) {
        return AuthoringUIMode.CLASSIC == AuthoringUIMode.fromRequest((ServletRequest)request);
    }

    public static boolean isTouch(SlingHttpServletRequest request) {
        return AuthoringUIMode.TOUCH == AuthoringUIMode.fromRequest((ServletRequest)request);
    }

    public static synchronized void configure(SlingSettingsService slingSettings) throws ConfigurationException {
        runmodes = slingSettings.getRunModes();
        isAuthor = runmodes.contains("author");
        isPublish = runmodes.contains("publish");
        if (isAuthor && isPublish) {
            throw new ConfigurationException(null, "Either 'author' or 'publish' run modes may be specified, not both.");
        }
    }
}

