/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.twitter.impl;

import com.adobe.acs.commons.twitter.impl.TwitterAdapterFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Twitter Client Adapter Factory", description="Adapter Factory to generate TwitterClient objects.", configurationPid="com.adobe.acs.commons.twitter.impl.TwitterAdapterFactory")
public class TwitterAdapterFactoryRegisterer {
    private static final Logger log = LoggerFactory.getLogger(TwitterAdapterFactory.class);
    private static final boolean DEFAULT_USE_SSL = true;
    @Property(label="HTTP Proxy Host", description="HTTP Proxy Host, leave blank for none")
    private static final String PROP_HTTP_PROXY_HOST = "http.proxy.host";
    @Property(label="HTTP Proxy Port", description="HTTP Proxy Port, leave 0 for none", intValue={0})
    private static final String PROP_HTTP_PROXY_PORT = "http.proxy.port";
    @Property(label="Use SSL", description="Use SSL Connections", boolValue={true})
    private static final String PROP_USE_SSL = "use.ssl";
    private ServiceRegistration<AdapterFactory> adapterFactoryServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        String httpProxyHost = PropertiesUtil.toString((Object)properties.get(PROP_HTTP_PROXY_HOST), null);
        int httpProxyPort = PropertiesUtil.toInteger((Object)properties.get(PROP_HTTP_PROXY_PORT), (int)0);
        boolean useSsl = PropertiesUtil.toBoolean((Object)properties.get(PROP_USE_SSL), (boolean)true);
        try {
            TwitterAdapterFactory adapterFactory = new TwitterAdapterFactory(httpProxyHost, httpProxyPort, useSsl);
            Hashtable<String, String[]> serviceProps = new Hashtable<String, String[]>();
            ((Dictionary)serviceProps).put("adaptables", new String[]{"com.day.cq.wcm.api.Page", "com.day.cq.wcm.webservicesupport.Configuration"});
            ((Dictionary)serviceProps).put("adapters", new String[]{"twitter4j.Twitter", "com.adobe.acs.commons.twitter.TwitterClient"});
            this.adapterFactoryServiceRegistration = bundleContext.registerService(AdapterFactory.class, (Object)adapterFactory, serviceProps);
        }
        catch (NoClassDefFoundError e) {
            log.info("Twitter4J Library not found. Not registering TwitterAdapterFactory.");
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.adapterFactoryServiceRegistration != null) {
            this.adapterFactoryServiceRegistration.unregister();
            this.adapterFactoryServiceRegistration = null;
        }
    }
}

