/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.form.FormComponent;
import com.adobe.acs.commons.mcp.util.AnnotatedFieldDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={SlingHttpServletRequest.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@DialogProvider
public class GeneratedDialog {
    @Inject
    @JsonIgnore
    private Resource resource;
    @Inject
    @JsonIgnore
    private SlingHttpServletRequest request;
    @Inject
    @JsonIgnore
    SlingScriptHelper sling;
    @JsonIgnore
    private FormComponent form;
    @JsonIgnore
    protected Map<String, FieldComponent> fieldComponents;
    @JsonIgnore
    private String formTitle = null;
    DialogProvider providerAnnotation = null;

    @PostConstruct
    public void init() {
        if (this.getResource() == null && this.getRequest() != null) {
            this.resource = this.getRequest().getResource();
        }
        this.getFieldComponents();
    }

    public void initAnnotationValues(DialogProvider annotation) {
        if (annotation == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)annotation.title())) {
            this.setFormTitle(annotation.title());
        }
        this.providerAnnotation = annotation;
    }

    @JsonIgnore
    public Map<String, FieldComponent> getFieldComponents() {
        if (this.fieldComponents == null) {
            this.fieldComponents = AnnotatedFieldDeserializer.getFormFields(this.getClass(), this.getSlingHelper());
        }
        return this.fieldComponents;
    }

    @JsonIgnore
    public Collection<String> getAllClientLibraries() {
        return this.getClientLibraries(FieldComponent.ClientLibraryType.ALL);
    }

    @JsonIgnore
    public Collection<String> getCssClientLibraries() {
        return this.getClientLibraries(FieldComponent.ClientLibraryType.CSS);
    }

    @JsonIgnore
    public Collection<String> getJsClientLibraries() {
        return this.getClientLibraries(FieldComponent.ClientLibraryType.JS);
    }

    private Collection<String> getClientLibraries(FieldComponent.ClientLibraryType type) {
        LinkedHashSet<String> allLibraries = new LinkedHashSet<String>();
        this.fieldComponents.values().stream().map(c -> c.getClientLibraryCategories().get((Object)type)).filter(v -> v != null).forEach(v -> allLibraries.addAll((Collection<String>)v));
        return allLibraries;
    }

    @JsonIgnore
    public Resource getResource() {
        return this.resource;
    }

    @JsonIgnore
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    @JsonIgnore
    public SlingScriptHelper getSlingHelper() {
        return this.sling;
    }

    @JsonIgnore
    public Resource getFormResource() {
        return this.getForm().buildComponentResource();
    }

    @JsonIgnore
    public FormComponent getForm() {
        if (this.form == null) {
            this.form = new FormComponent();
            if (this.providerAnnotation != null) {
                this.form.applyDialogProviderSettings(this.providerAnnotation);
            }
            if (this.formTitle != null) {
                this.form.getProperties().put("jcr:title", this.formTitle);
            }
            if (this.sling != null) {
                this.form.setHelper(this.sling);
                this.form.setPath(this.sling.getRequest().getResource().getPath());
                this.form.setAsync(true);
                this.form.getProperties().put("granite:id", "mcp-generated-form");
            } else {
                this.form.setPath("/form");
            }
            this.getFieldComponents().forEach((name, component) -> this.form.addComponent((String)name, (FieldComponent)component));
        }
        return this.form;
    }

    public String getFormTitle() {
        return this.formTitle;
    }

    public void setFormTitle(String formTitle) {
        this.formTitle = formTitle;
    }
}

