/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractContainerComponent;
import com.adobe.acs.commons.mcp.form.AbstractGroupingContainerComponent;
import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class FormComponent
extends AbstractContainerComponent {
    private static final String ACTION_OPT = "action";
    private static final String ASYNC_OPT = "async";
    private static final String AUTOCOMPLETE_OPT = "autocomplete";
    private static final String AUTOSUBMIT_FORM_OPT = "autosubmitForm";
    private static final String DATA_PATH_OPT = "dataPath";
    private static final String ENCTYPE_OPT = "enctype";
    private static final String FOUNDATION_FORM_OPT = "foundationForm";
    private static final String LOADING_MASK_OPT = "loadingMask";
    private static final String MARGIN_OPT = "margin";
    private static final String MAXIMIZED_OPT = "maximized";
    private static final String METHOD_OPT = "method";
    private static final String NAME_NOT_FOUND_MODE_OPT = "nameNotFoundMode";
    private static final String NOVALIDATE_OPT = "novalidate";
    private static final String STYLE_OPT = "style";
    private static final String SUCCESSRESPONSE_OPT = "successresponse";
    private static final String TARGET_OPT = "target";
    private static final String UI_OPT = "ui";
    private String action = "";
    private boolean async = false;
    private String autocomplete = "";
    private boolean autosubmitForm = false;
    private String dataPath = null;
    private String enctype = "multipart/form-data";
    private boolean foundationForm = true;
    private boolean loadingMask = true;
    private boolean margin = true;
    private boolean maximized = false;
    private String method = "post";
    private String nameNotFoundMode = "ignore-freshness";
    private boolean novalidate = true;
    private String style = "vertical";
    private boolean successresponse = false;
    private String target = "";
    private String ui = "";

    public FormComponent() {
        this.setResourceType("granite/ui/components/coral/foundation/form");
        this.setGroupingContainer(new AbstractGroupingContainerComponent.TabsComponent());
    }

    @Override
    public void init() {
        super.init();
    }

    private void initOptions() {
        if (!StringUtils.isEmpty((String)this.getPath()) && StringUtils.isEmpty((String)this.action)) {
            this.setAction(this.getPath());
        }
        if (!StringUtils.isEmpty((String)this.getPath()) && StringUtils.isEmpty((String)this.dataPath)) {
            this.setDataPath(this.getPath());
        }
        this.getOption(ACTION_OPT).ifPresent(this::setAction);
        this.getBooleanOption(ASYNC_OPT).ifPresent(this::setAsync);
        this.getOption(AUTOCOMPLETE_OPT).ifPresent(this::setAutocomplete);
        this.getBooleanOption(AUTOSUBMIT_FORM_OPT).ifPresent(this::setAutosubmitForm);
        this.getOption(DATA_PATH_OPT).ifPresent(this::setDataPath);
        this.getOption(ENCTYPE_OPT).ifPresent(this::setEnctype);
        this.getBooleanOption(FOUNDATION_FORM_OPT).ifPresent(this::setFoundationForm);
        this.getBooleanOption(LOADING_MASK_OPT).ifPresent(this::setLoadingMask);
        this.getBooleanOption(MARGIN_OPT).ifPresent(this::setMargin);
        this.getBooleanOption(MAXIMIZED_OPT).ifPresent(this::setMaximized);
        this.getOption(METHOD_OPT).ifPresent(this::setMethod);
        this.getOption(NAME_NOT_FOUND_MODE_OPT).ifPresent(this::setNameNotFoundMode);
        this.getBooleanOption(NOVALIDATE_OPT).ifPresent(this::setNovalidate);
        this.getOption(STYLE_OPT).ifPresent(this::setStyle);
        this.getBooleanOption(SUCCESSRESPONSE_OPT).ifPresent(this::setSuccessresponse);
        this.getOption(TARGET_OPT).ifPresent(this::setTarget);
        this.getOption(UI_OPT).ifPresent(this::setUi);
    }

    @Override
    public Resource buildComponentResource() {
        this.initOptions();
        Map<String, Object> properties = this.getProperties();
        properties.put(ACTION_OPT, this.getAction());
        properties.put(ASYNC_OPT, this.isAsync());
        properties.put(AUTOCOMPLETE_OPT, this.getAutocomplete());
        properties.put(AUTOSUBMIT_FORM_OPT, this.isAutosubmitForm());
        properties.put(DATA_PATH_OPT, this.getDataPath());
        properties.put(ENCTYPE_OPT, this.getEnctype());
        properties.put(FOUNDATION_FORM_OPT, this.isFoundationForm());
        properties.put(LOADING_MASK_OPT, this.isLoadingMask());
        properties.put(MARGIN_OPT, this.isMargin());
        properties.put(MAXIMIZED_OPT, this.isMaximized());
        properties.put(METHOD_OPT, this.getMethod());
        properties.put(NAME_NOT_FOUND_MODE_OPT, this.getNameNotFoundMode());
        properties.put(NOVALIDATE_OPT, this.isNovalidate());
        properties.put(STYLE_OPT, this.getStyle());
        properties.put(SUCCESSRESPONSE_OPT, this.isSuccessresponse());
        properties.put(TARGET_OPT, this.getTarget());
        properties.put(UI_OPT, this.getUi());
        this.purgeEmptyProperties();
        AbstractResourceImpl res = new AbstractResourceImpl(this.getPath(), this.getResourceType(), this.getResourceSuperType(), properties);
        if (this.getHelper() != null) {
            res.setResourceResolver(this.getHelper().getRequest().getResourceResolver());
        }
        AbstractResourceImpl items = this.generateItemsResource(this.getPath() + "/items", true);
        if (this.isForceDotSlashPrefix()) {
            this.correctNameAttribute((Resource)items);
        }
        res.addChild((Resource)items);
        return res;
    }

    private void correctNameAttribute(Resource res) {
        String name = (String)res.getValueMap().get("name", String.class);
        boolean hasResourceType = StringUtils.isNotBlank((String)res.getResourceType());
        if (name != null && !name.startsWith("./") && hasResourceType) {
            res.getValueMap().put((Object)"name", (Object)("./" + name));
        }
        res.getChildren().forEach(this::correctNameAttribute);
    }

    @Override
    public boolean hasCategories(Collection<FieldComponent> values) {
        return this.getDialogStyle() == DialogProvider.DialogStyle.COMPONENT || super.hasCategories(values);
    }

    public String getMethod() {
        return this.method;
    }

    public final void setMethod(String method) {
        this.method = method;
    }

    public String getAction() {
        return this.action;
    }

    public final void setAction(String action) {
        this.action = action;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public final void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public String getTarget() {
        return this.target;
    }

    public final void setTarget(String target) {
        this.target = target;
    }

    public String getAutocomplete() {
        return this.autocomplete;
    }

    public final void setAutocomplete(String autocomplete) {
        this.autocomplete = autocomplete;
    }

    public boolean isNovalidate() {
        return this.novalidate;
    }

    public final void setNovalidate(boolean novalidate) {
        this.novalidate = novalidate;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public final void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getNameNotFoundMode() {
        return this.nameNotFoundMode;
    }

    public final void setNameNotFoundMode(String nameNotFoundMode) {
        this.nameNotFoundMode = nameNotFoundMode;
    }

    public boolean isAutosubmitForm() {
        return this.autosubmitForm;
    }

    public final void setAutosubmitForm(boolean autosubmitForm) {
        this.autosubmitForm = autosubmitForm;
    }

    public boolean isMargin() {
        return this.margin;
    }

    public final void setMargin(boolean margin) {
        this.margin = margin;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public final void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public boolean isFoundationForm() {
        return this.foundationForm;
    }

    public final void setFoundationForm(boolean foundationForm) {
        this.foundationForm = foundationForm;
    }

    public boolean isAsync() {
        return this.async;
    }

    public final void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isLoadingMask() {
        return this.loadingMask;
    }

    public final void setLoadingMask(boolean loadingMask) {
        this.loadingMask = loadingMask;
    }

    public String getUi() {
        return this.ui;
    }

    public final void setUi(String ui) {
        this.ui = ui;
    }

    public boolean isSuccessresponse() {
        return this.successresponse;
    }

    public final void setSuccessresponse(boolean successresponse) {
        this.successresponse = successresponse;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

