/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ccvar.impl;

import com.adobe.acs.commons.ccvar.ContentVariableProvider;
import com.adobe.acs.commons.ccvar.PropertyConfigService;
import com.adobe.acs.commons.ccvar.util.PropertyAggregatorUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContentVariableProvider.class})
public class AllPagePropertiesContentVariableProvider
implements ContentVariableProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AllPagePropertiesContentVariableProvider.class);
    public static final String PAGE_PROP_PREFIX = "page_properties";
    private static final String INHERITED_PAGE_PROP_PREFIX = "inherited_page_properties";
    @Reference
    private PropertyConfigService propertyConfigService;

    @Override
    public void addProperties(Map<String, Object> map, SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        if (pageManager == null) {
            LOG.warn("PageManager was null, skipping properties.");
            return;
        }
        Page page = pageManager.getContainingPage(resource);
        if (page == null) {
            LOG.warn("No containing page found for resource at {}", (Object)resource.getPath());
            return;
        }
        this.addPagePropertiesToMap(map, page, PAGE_PROP_PREFIX, this.propertyConfigService);
        while (page != null) {
            this.addPagePropertiesToMap(map, page, INHERITED_PAGE_PROP_PREFIX, this.propertyConfigService);
            page = page.getParent();
        }
    }

    private void addPagePropertiesToMap(Map<String, Object> map, Page page, String prefix, PropertyConfigService propertyConfigService) {
        ValueMap pageProperties = page.getProperties();
        PropertyAggregatorUtil.addPropertiesToMap(map, pageProperties.entrySet(), prefix, false, propertyConfigService);
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request) {
        PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
        if (pageManager == null) {
            LOG.warn("PageManager is null, not accepting this request.");
            return false;
        }
        Page page = pageManager.getContainingPage(request.getResource());
        return page != null && page.getPath().startsWith("/content/");
    }
}

