/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.DefaultChecksumGeneratorOptions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.codec.digest.DigestUtils;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class JSONGenerator {
    private static final Logger log = LoggerFactory.getLogger(ChecksumGenerator.class);

    private JSONGenerator() {
    }

    public static void generateJSON(Session session, String path, JsonWriter out) throws RepositoryException, IOException {
        HashSet<String> paths = new HashSet<String>();
        paths.add(path);
        JSONGenerator.generateJSON(session, paths, new DefaultChecksumGeneratorOptions(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJSON(Session session, Set<String> paths, ChecksumGeneratorOptions opts, JsonWriter out) throws RepositoryException, IOException {
        Node node = null;
        if (paths.size() > 1) {
            out.beginArray();
        }
        for (String path : paths) {
            out.beginObject();
            try {
                Item item;
                if (session.itemExists(path) && (item = session.getItem(path)).isNode()) {
                    node = (Node)item;
                }
                JSONGenerator.traverseTree(node, opts, out);
            }
            catch (PathNotFoundException e) {
                out.name("ERROR");
                out.value("WARN: Path doesn't exist: " + path);
            }
            catch (RepositoryException e) {
                out.name("ERROR");
                out.value("Unable to read path: " + e.getMessage());
            }
            finally {
                out.endObject();
            }
        }
        if (paths.size() > 1) {
            out.endArray();
        }
    }

    private static void traverseTree(Node node, ChecksumGeneratorOptions opts, JsonWriter out) throws IOException {
        Set<String> nodeTypes = opts.getIncludedNodeTypes();
        Set<String> nodeTypeExcludes = opts.getExcludedNodeTypes();
        if (node != null) {
            try {
                String primaryNodeType = node.getPrimaryNodeType().getName();
                if (nodeTypes.contains(primaryNodeType) && !nodeTypeExcludes.contains(primaryNodeType)) {
                    JSONGenerator.generateNodeJSON(node, opts, out);
                } else {
                    NodeIterator nodeIterator = node.getNodes();
                    while (nodeIterator.hasNext()) {
                        primaryNodeType = node.getPrimaryNodeType().getName();
                        Node child = nodeIterator.nextNode();
                        if (nodeTypes.contains(primaryNodeType)) {
                            JSONGenerator.generateNodeJSON(child, opts, out);
                            continue;
                        }
                        JSONGenerator.traverseTree(child, opts, out);
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Error while traversing tree {}", (Object)e.getMessage());
            }
        }
    }

    private static void generateNodeJSON(Node node, ChecksumGeneratorOptions opts, JsonWriter out) throws RepositoryException, IOException {
        out.name(node.getPath());
        out.beginObject();
        JSONGenerator.outputProperties(node, opts, out);
        JSONGenerator.outputChildNodes(node, opts, out);
        out.endObject();
    }

    private static void generateSubnodeJSON(Node node, ChecksumGeneratorOptions opts, JsonWriter out) throws RepositoryException, IOException {
        out.name(node.getName());
        out.beginObject();
        JSONGenerator.outputProperties(node, opts, out);
        JSONGenerator.outputChildNodes(node, opts, out);
        out.endObject();
    }

    private static void outputProperties(Node node, ChecksumGeneratorOptions opts, JsonWriter out) throws RepositoryException, ValueFormatException, IOException {
        Set<String> excludes = opts.getExcludedProperties();
        TreeMap<String, Property> props = new TreeMap<String, Property>();
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (excludes.contains(property.getName())) continue;
            props.put(property.getName(), property);
        }
        for (Property property : props.values()) {
            JSONGenerator.outputProperty(property, opts, out);
        }
    }

    private static void outputProperty(Property property, ChecksumGeneratorOptions opts, JsonWriter out) throws RepositoryException, IOException {
        Set<String> sortValues = opts.getSortedProperties();
        if (property.isMultiple()) {
            out.name(property.getName());
            out.beginArray();
            boolean isSortedValues = sortValues.contains(property.getName());
            Value[] values = property.getValues();
            TreeMap<String, Value> sortedValueMap = new TreeMap<String, Value>();
            for (Value v : values) {
                int type = v.getType();
                if (type == 2) {
                    if (isSortedValues) {
                        try {
                            InputStream stream = v.getBinary().getStream();
                            String ckSum = DigestUtils.sha1Hex((InputStream)stream);
                            stream.close();
                            sortedValueMap.put(ckSum, v);
                        }
                        catch (IOException e) {
                            sortedValueMap.put("ERROR: generating hash for binary of " + property.getPath() + " : " + e.getMessage(), v);
                        }
                        continue;
                    }
                    JSONGenerator.outputPropertyValue(property, v, out);
                    continue;
                }
                String val = v.getString();
                if (isSortedValues) {
                    sortedValueMap.put(val, v);
                    continue;
                }
                JSONGenerator.outputPropertyValue(property, v, out);
            }
            if (isSortedValues) {
                for (Value v : sortedValueMap.values()) {
                    JSONGenerator.outputPropertyValue(property, v, out);
                }
            }
            out.endArray();
        } else {
            out.name(property.getName());
            JSONGenerator.outputPropertyValue(property, property.getValue(), out);
        }
    }

    private static void outputChildNodes(Node node, ChecksumGeneratorOptions opts, JsonWriter out) throws RepositoryException, IOException {
        Set<String> nodeTypeExcludes = opts.getExcludedNodeTypes();
        NodeIterator nodeIterator = node.getNodes();
        TreeMap<String, Node> childSortMap = new TreeMap<String, Node>();
        boolean hasOrderedChildren = false;
        try {
            hasOrderedChildren = node.getPrimaryNodeType().hasOrderableChildNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            if (nodeTypeExcludes.contains(child.getPrimaryNodeType().getName())) continue;
            if (hasOrderedChildren) {
                out.name(child.getName());
                out.beginObject();
                JSONGenerator.generateSubnodeJSON(child, opts, out);
                out.endObject();
                continue;
            }
            childSortMap.put(child.getName(), child);
        }
        for (Node child : childSortMap.values()) {
            out.name(child.getName());
            out.beginObject();
            JSONGenerator.generateSubnodeJSON(child, opts, out);
            out.endObject();
        }
    }

    private static void outputPropertyValue(Property property, Value value, JsonWriter out) throws RepositoryException, IOException {
        if (value.getType() == 1) {
            out.value(value.getString());
        } else if (value.getType() == 2) {
            try {
                InputStream stream = value.getBinary().getStream();
                String ckSum = DigestUtils.sha1Hex((InputStream)stream);
                stream.close();
                out.value(ckSum);
            }
            catch (IOException e) {
                out.value("ERROR: calculating hash for binary of " + property.getPath() + " : " + e.getMessage());
            }
        } else if (value.getType() == 6) {
            out.value(value.getBoolean());
        } else if (value.getType() == 5) {
            Calendar cal = value.getDate();
            if (cal != null) {
                out.beginObject();
                out.name("type");
                out.value(PropertyType.nameFromValue((int)value.getType()));
                out.name("val");
                out.value(cal.getTime().toString());
                out.endObject();
            }
        } else if (value.getType() == 3) {
            out.value(value.getLong());
        } else if (value.getType() == 4) {
            out.value(value.getDouble());
        } else if (value.getType() == 12) {
            out.value((Number)value.getDecimal());
        } else {
            out.beginObject();
            out.name("type");
            out.value(PropertyType.nameFromValue((int)value.getType()));
            out.name("val");
            out.value(value.getString());
            out.endObject();
        }
    }
}

