/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.FirstSessionDelayManager;
import com.adjust.sdk.GlobalParameters;
import com.adjust.sdk.LicenseData;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ReferrerDetails;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PackageFactory {
    private static final String ADJUST_PREFIX = "adjust_";

    public static ActivityPackage buildReftagSdkClickPackage(String string, long l, ActivityState object, AdjustConfig adjustConfig, DeviceInfo deviceInfo, GlobalParameters globalParameters, FirstSessionDelayManager firstSessionDelayManager, ActivityHandler.InternalState internalState) {
        block8: {
            Object[] objectArray;
            Object[] objectArray2;
            block5: {
                UnsupportedEncodingException unsupportedEncodingException2;
                block7: {
                    IllegalArgumentException illegalArgumentException2;
                    block6: {
                        if (string == null || string.length() == 0) break block8;
                        try {
                            objectArray2 = URLDecoder.decode(string, "UTF-8");
                            break block5;
                        }
                        catch (Exception exception) {
                        }
                        catch (IllegalArgumentException illegalArgumentException2) {
                            break block6;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException2) {
                            break block7;
                        }
                        objectArray = "malformed";
                        objectArray2 = exception.getMessage();
                        Object[] objectArray3 = new Object[1];
                        Object[] objectArray4 = objectArray3;
                        objectArray3[0] = objectArray2;
                        AdjustFactory.getLogger().error("Referrer decoding failed. Message: (%s)", objectArray4);
                        objectArray2 = objectArray;
                        break block5;
                    }
                    objectArray = "malformed";
                    objectArray2 = illegalArgumentException2.getMessage();
                    Object[] objectArray5 = new Object[1];
                    Object[] objectArray6 = objectArray5;
                    objectArray5[0] = objectArray2;
                    AdjustFactory.getLogger().error("Referrer decoding failed due to IllegalArgumentException. Message: (%s)", objectArray6);
                    objectArray2 = objectArray;
                    break block5;
                }
                objectArray = "malformed";
                objectArray2 = unsupportedEncodingException2.getMessage();
                Object[] objectArray7 = new Object[1];
                Object[] objectArray8 = objectArray7;
                objectArray7[0] = objectArray2;
                AdjustFactory.getLogger().error("Referrer decoding failed due to UnsupportedEncodingException. Message: (%s)", objectArray8);
                objectArray2 = objectArray;
            }
            Object[] objectArray9 = new Object[1];
            objectArray = objectArray9;
            objectArray9[0] = objectArray2;
            AdjustFactory.getLogger().verbose("Referrer to parse (%s)", objectArray);
            UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
            urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
            urlQuerySanitizer.setAllowUnregisteredParamaters(true);
            urlQuerySanitizer.parseQuery((String)objectArray2);
            object = PackageFactory.queryStringClickPackageBuilder(urlQuerySanitizer.getParameterList(), (ActivityState)object, adjustConfig, deviceInfo, globalParameters, firstSessionDelayManager, internalState);
            if (object == null) {
                return null;
            }
            ((PackageBuilder)object).referrer = objectArray2;
            ((PackageBuilder)object).clickTimeInMilliseconds = l;
            ((PackageBuilder)object).rawReferrer = string;
            return ((PackageBuilder)object).buildClickPackage("reftag");
        }
        return null;
    }

    public static ActivityPackage buildDeeplinkSdkClickPackage(Uri uri, Uri uri2, long l, ActivityState object, AdjustConfig adjustConfig, DeviceInfo deviceInfo, GlobalParameters globalParameters, FirstSessionDelayManager firstSessionDelayManager, ActivityHandler.InternalState internalState) {
        block10: {
            Object[] objectArray;
            String string;
            block7: {
                UnsupportedEncodingException unsupportedEncodingException2;
                block9: {
                    IllegalArgumentException illegalArgumentException2;
                    block8: {
                        if (uri == null) {
                            return null;
                        }
                        string = uri.toString();
                        if (string == null || string.length() == 0) break block10;
                        try {
                            string = URLDecoder.decode(string, "UTF-8");
                            break block7;
                        }
                        catch (Exception exception) {
                        }
                        catch (IllegalArgumentException illegalArgumentException2) {
                            break block8;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException2) {
                            break block9;
                        }
                        objectArray = exception.getMessage();
                        Object[] objectArray2 = new Object[1];
                        Object[] objectArray3 = objectArray2;
                        objectArray2[0] = objectArray;
                        AdjustFactory.getLogger().error("Deeplink url decoding failed. Message: (%s)", objectArray3);
                        break block7;
                    }
                    objectArray = illegalArgumentException2.getMessage();
                    Object[] objectArray4 = new Object[1];
                    Object[] objectArray5 = objectArray4;
                    objectArray4[0] = objectArray;
                    AdjustFactory.getLogger().error("Deeplink url decoding failed due to IllegalArgumentException. Message: (%s)", objectArray5);
                    break block7;
                }
                objectArray = unsupportedEncodingException2.getMessage();
                Object[] objectArray6 = new Object[1];
                Object[] objectArray7 = objectArray6;
                objectArray6[0] = objectArray;
                AdjustFactory.getLogger().error("Deeplink url decoding failed due to UnsupportedEncodingException. Message: (%s)", objectArray7);
            }
            Object[] objectArray8 = new Object[1];
            objectArray = objectArray8;
            objectArray8[0] = string;
            AdjustFactory.getLogger().verbose("Url to parse (%s)", objectArray);
            UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
            urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
            urlQuerySanitizer.setAllowUnregisteredParamaters(true);
            urlQuerySanitizer.parseUrl(string);
            object = PackageFactory.queryStringClickPackageBuilder(urlQuerySanitizer.getParameterList(), (ActivityState)object, adjustConfig, deviceInfo, globalParameters, firstSessionDelayManager, internalState);
            if (object == null) {
                return null;
            }
            ((PackageBuilder)object).deeplink = uri.toString();
            ((PackageBuilder)object).clickTimeInMilliseconds = l;
            if (uri2 != null) {
                ((PackageBuilder)object).referrer = uri2.toString();
            }
            return ((PackageBuilder)object).buildClickPackage("deeplink");
        }
        return null;
    }

    public static ActivityPackage buildInstallReferrerSdkClickPackage(ReferrerDetails referrerDetails, String string, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, GlobalParameters globalParameters, FirstSessionDelayManager firstSessionDelayManager, ActivityHandler.InternalState internalState) {
        PackageBuilder packageBuilder;
        long l = System.currentTimeMillis();
        PackageBuilder packageBuilder2 = packageBuilder;
        packageBuilder2(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = internalState;
        packageBuilder2.referrer = referrerDetails.installReferrer;
        packageBuilder2.clickTimeInSeconds = referrerDetails.referrerClickTimestampSeconds;
        packageBuilder2.installBeginTimeInSeconds = referrerDetails.installBeginTimestampSeconds;
        packageBuilder2.clickTimeServerInSeconds = referrerDetails.referrerClickTimestampServerSeconds;
        packageBuilder2.installBeginTimeServerInSeconds = referrerDetails.installBeginTimestampServerSeconds;
        packageBuilder2.installVersion = referrerDetails.installVersion;
        packageBuilder2.googlePlayInstant = referrerDetails.googlePlayInstant;
        packageBuilder2.isClick = referrerDetails.isClick;
        packageBuilder.referrerApi = string;
        return packageBuilder.buildClickPackage("install_referrer");
    }

    public static ActivityPackage buildLicenseVerificationSdkClickPackage(LicenseData licenseData, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, GlobalParameters globalParameters, FirstSessionDelayManager firstSessionDelayManager, ActivityHandler.InternalState internalState) {
        PackageBuilder packageBuilder;
        long l = System.currentTimeMillis();
        PackageBuilder packageBuilder2 = packageBuilder;
        packageBuilder2(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = internalState;
        packageBuilder.licenseData = licenseData;
        return packageBuilder.buildClickPackage("google_lvl");
    }

    public static ActivityPackage buildPreinstallSdkClickPackage(String string, String string2, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, GlobalParameters globalParameters, FirstSessionDelayManager firstSessionDelayManager) {
        if (string != null && string.length() != 0) {
            PackageBuilder packageBuilder;
            long l = System.currentTimeMillis();
            PackageBuilder packageBuilder2 = packageBuilder;
            packageBuilder2(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l);
            packageBuilder2.preinstallPayload = string;
            packageBuilder.preinstallLocation = string2;
            return packageBuilder.buildClickPackage("preinstall");
        }
        return null;
    }

    private static PackageBuilder queryStringClickPackageBuilder(List<UrlQuerySanitizer.ParameterValuePair> object, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, GlobalParameters globalParameters, FirstSessionDelayManager firstSessionDelayManager, ActivityHandler.InternalState internalState) {
        AdjustAttribution adjustAttribution;
        LinkedHashMap linkedHashMap;
        if (object == null) {
            return null;
        }
        List<UrlQuerySanitizer.ParameterValuePair> list = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        AdjustAttribution adjustAttribution2 = adjustAttribution;
        adjustAttribution = new AdjustAttribution();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : list) {
            PackageFactory.readQueryString(parameterValuePair.mParameter, parameterValuePair.mValue, (Map<String, String>)object, adjustAttribution2);
        }
        long l = System.currentTimeMillis();
        String string = (String)object.remove("reftag");
        if (activityState != null) {
            activityState.lastInterval = l - activityState.lastActivity;
        }
        new PackageBuilder(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).internalState = internalState;
        new PackageBuilder(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).extraParameters = object;
        new PackageBuilder(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).attribution = adjustAttribution2;
        new PackageBuilder(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).reftag = string;
        return new PackageBuilder(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l);
    }

    private static boolean readQueryString(String string, String string2, Map<String, String> map, AdjustAttribution adjustAttribution) {
        if (string != null && string2 != null) {
            if (!string.startsWith(ADJUST_PREFIX)) {
                return false;
            }
            if ((string = string.substring(7)).length() == 0) {
                return false;
            }
            if (string2.length() == 0) {
                return false;
            }
            if (!PackageFactory.tryToSetAttribution(adjustAttribution, string, string2)) {
                map.put(string, string2);
            }
            return true;
        }
        return false;
    }

    private static boolean tryToSetAttribution(AdjustAttribution adjustAttribution, String string, String string2) {
        if (string.equals("tracker")) {
            adjustAttribution.trackerName = string2;
            return true;
        }
        if (string.equals("campaign")) {
            adjustAttribution.campaign = string2;
            return true;
        }
        if (string.equals("adgroup")) {
            adjustAttribution.adgroup = string2;
            return true;
        }
        if (string.equals("creative")) {
            adjustAttribution.creative = string2;
            return true;
        }
        return false;
    }
}

