/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPurchaseVerificationHandler;
import com.adjust.sdk.PurchaseVerificationResponseData;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class PurchaseVerificationHandler
implements IPurchaseVerificationHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "PurchaseVerificationHandler";
    private boolean paused;
    private ILogger logger;
    private boolean isSendingPurchaseVerificationPackage;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;
    private long lastPackageRetryInMilli = 0L;

    public PurchaseVerificationHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.init(iActivityHandler, bl, iActivityPackageSender);
        this.logger = AdjustFactory.getLogger();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    private void sendPurchaseVerificationPackageI(ActivityPackage objectArray) {
        PurchaseVerificationHandler purchaseVerificationHandler = object;
        purchaseVerificationHandler.packageQueue.add((ActivityPackage)objectArray);
        Object object = ((PurchaseVerificationHandler)object).packageQueue.size();
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = object;
        purchaseVerificationHandler.logger.debug("Added purchase_verification %d", objectArray3);
        object = objectArray.getExtendedString();
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = object;
        purchaseVerificationHandler.logger.verbose("%s", objectArray);
        purchaseVerificationHandler.sendNextPurchaseVerificationPackage();
    }

    private void sendNextPurchaseVerificationPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackageI();
            }
        });
    }

    private void sendNextPurchaseVerificationPackageI() {
        IActivityHandler iActivityHandler = (IActivityHandler)((PurchaseVerificationHandler)((Object)activityPackage)).activityHandlerWeakRef.get();
        if (iActivityHandler.getActivityState() == null || ((PurchaseVerificationHandler)((Object)activityPackage)).packageQueue.isEmpty()) {
            return;
        }
        if (iActivityHandler.getActivityState().isGdprForgotten) {
            ((PurchaseVerificationHandler)((Object)activityPackage)).logger.debug("purchase_verification request won't be sent for GDPR forgotten user", new Object[0]);
            return;
        }
        if (((PurchaseVerificationHandler)((Object)activityPackage)).paused) {
            ((PurchaseVerificationHandler)((Object)activityPackage)).logger.debug("PurchaseVerificationHandler is paused", new Object[0]);
            return;
        }
        if (((PurchaseVerificationHandler)((Object)activityPackage)).isSendingPurchaseVerificationPackage) {
            ((PurchaseVerificationHandler)((Object)activityPackage)).logger.debug("PurchaseVerificationHandler is is already sending a package", new Object[0]);
            return;
        }
        long l = ((PurchaseVerificationHandler)((Object)activityPackage)).waitTime();
        if (l > 0L) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public final void run() {
                    3 v0 = this;
                    PurchaseVerificationHandler.access$202(v0.PurchaseVerificationHandler.this, 0L);
                    v0.PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
                }
            };
            ((PurchaseVerificationHandler)((Object)activityPackage)).scheduler.schedule(runnable2, l);
            return;
        }
        PurchaseVerificationHandler purchaseVerificationHandler = activityPackage;
        ActivityPackage activityPackage = purchaseVerificationHandler.packageQueue.get(0);
        purchaseVerificationHandler.isSendingPurchaseVerificationPackage = true;
        purchaseVerificationHandler.sendPurchaseVerificationPackageSync(activityPackage);
    }

    private void sendPurchaseVerificationPackageSync(ActivityPackage object) {
        PurchaseVerificationResponseData purchaseVerificationResponseData;
        Object object2;
        block9: {
            block10: {
                block7: {
                    block8: {
                        PurchaseVerificationHandler purchaseVerificationHandler = this;
                        object2 = (IActivityHandler)purchaseVerificationHandler.activityHandlerWeakRef.get();
                        if (!((object = purchaseVerificationHandler.activityPackageSender.sendActivityPackageSync((ActivityPackage)object, null)) instanceof PurchaseVerificationResponseData)) break block7;
                        this.isSendingPurchaseVerificationPackage = false;
                        purchaseVerificationResponseData = (PurchaseVerificationResponseData)object;
                        if (purchaseVerificationResponseData.jsonResponse != null) break block8;
                        object = purchaseVerificationResponseData.message;
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = object;
                        this.logger.error("Could not get purchase_verification JSON response with message: %s", objectArray2);
                        break block9;
                    }
                    if (object2 != null) break block10;
                }
                return;
            }
            if (purchaseVerificationResponseData.trackingState == TrackingState.OPTED_OUT) {
                object2.gotOptOutResponse();
                return;
            }
            if (purchaseVerificationResponseData.willRetry) {
                object2 = ((ResponseData)object).retryIn;
                if (object2 != null && (Long)object2 > 0L) {
                    long l;
                    this.lastPackageRetryInMilli = l = ((ResponseData)object).retryIn.longValue();
                    object = l;
                    Object[] objectArray = new Object[1];
                    Object[] objectArray3 = objectArray;
                    objectArray[0] = object;
                    this.logger.error("Retrying purchase_verification package with retry in %d ms", objectArray3);
                }
                this.sendNextPurchaseVerificationPackage();
                return;
            }
            this.lastPackageRetryInMilli = 0L;
        }
        if (!this.packageQueue.isEmpty()) {
            this.packageQueue.remove(0);
        }
        object2.finishedTrackingActivity(purchaseVerificationResponseData);
        this.sendNextPurchaseVerificationPackage();
    }

    private long waitTime() {
        long l = ((PurchaseVerificationHandler)((Object)l2)).lastPackageRetryInMilli;
        if (l > 0L) {
            PurchaseVerificationHandler purchaseVerificationHandler = l2;
            Long l2 = l;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l2;
            purchaseVerificationHandler.logger.verbose("Waiting for %d ms before retrying purchase_verification with retry_in", objectArray2);
            return purchaseVerificationHandler.lastPackageRetryInMilli;
        }
        return 0L;
    }

    public static /* synthetic */ long access$202(PurchaseVerificationHandler purchaseVerificationHandler, long l) {
        purchaseVerificationHandler.lastPackageRetryInMilli = l;
        return l;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        PurchaseVerificationHandler purchaseVerificationHandler2 = this;
        purchaseVerificationHandler2.paused = bl ^ true;
        purchaseVerificationHandler2.packageQueue = new ArrayList<ActivityPackage>();
        purchaseVerificationHandler2.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        purchaseVerificationHandler.activityPackageSender = iActivityPackageSender;
        purchaseVerificationHandler.isSendingPurchaseVerificationPackage = false;
        purchaseVerificationHandler.lastPackageRetryInMilli = 0L;
    }

    @Override
    public void pauseSending() {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        purchaseVerificationHandler.paused = true;
        purchaseVerificationHandler.isSendingPurchaseVerificationPackage = false;
        purchaseVerificationHandler.lastPackageRetryInMilli = 0L;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextPurchaseVerificationPackage();
    }

    @Override
    public void sendPurchaseVerificationPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PurchaseVerificationHandler.this.sendPurchaseVerificationPackageI(activityPackage);
            }
        });
    }

    @Override
    public void teardown() {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        purchaseVerificationHandler.logger.verbose("PurchaseVerificationHandler teardown", new Object[0]);
        WeakReference<IActivityHandler> weakReference = purchaseVerificationHandler.scheduler;
        if (weakReference != null) {
            weakReference.teardown();
        }
        if ((weakReference = this.packageQueue) != null) {
            weakReference.clear();
        }
        if ((weakReference = this.activityHandlerWeakRef) != null) {
            weakReference.clear();
        }
        PurchaseVerificationHandler purchaseVerificationHandler2 = this;
        purchaseVerificationHandler2.logger = null;
        purchaseVerificationHandler2.packageQueue = null;
        purchaseVerificationHandler2.scheduler = null;
        purchaseVerificationHandler2.isSendingPurchaseVerificationPackage = false;
        purchaseVerificationHandler2.lastPackageRetryInMilli = 0L;
    }
}

