/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class UtilNetworking {
    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public static IConnectionOptions createDefaultConnectionOptions() {
        return new IConnectionOptions(){

            @Override
            public final void applyConnectionOptions(HttpsURLConnection httpsURLConnection, String string, int n) {
                HttpsURLConnection httpsURLConnection2 = httpsURLConnection;
                httpsURLConnection2.setRequestProperty("Client-SDK", string);
                httpsURLConnection2.setConnectTimeout(n);
                httpsURLConnection2.setReadTimeout(n);
            }
        };
    }

    public static IHttpsURLConnectionProvider createDefaultHttpsURLConnectionProvider() {
        return new IHttpsURLConnectionProvider(){

            @Override
            public final HttpsURLConnection generateHttpsURLConnection(URL uRL) {
                return (HttpsURLConnection)uRL.openConnection();
            }
        };
    }

    public static String extractJsonString(JSONObject object, String string) {
        if ((object = object.opt(string)) instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static Long extractJsonLong(JSONObject object, String string) {
        if ((object = object.opt(string)) instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            long l;
            try {
                l = (long)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
            return l;
        }
        return null;
    }

    public static int extractJsonInt(JSONObject object, String string) {
        if ((object = object.opt(string)) instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public static interface IHttpsURLConnectionProvider {
        public HttpsURLConnection generateHttpsURLConnection(URL var1);
    }

    public static interface IConnectionOptions {
        public void applyConnectionOptions(HttpsURLConnection var1, String var2, int var3);
    }
}

