/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.FirstSessionDelayManager;
import com.adjust.sdk.GlobalParameters;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import com.adjust.sdk.scheduler.TimerOnce;
import java.lang.ref.WeakReference;

public class AttributionHandler
implements IAttributionHandler,
IActivityPackageSender.ResponseDataCallbackSubscriber {
    private static final String ATTRIBUTION_TIMER_NAME = "Attribution timer";
    private boolean paused;
    private String lastInitiatedBy;
    private IActivityPackageSender activityPackageSender;
    private ILogger logger = AdjustFactory.getLogger();
    private TimerOnce timer;
    private ThreadScheduler scheduler = new SingleThreadCachedScheduler("AttributionHandler");
    private WeakReference<IActivityHandler> activityHandlerWeakRef;

    public AttributionHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.timer = new TimerOnce(new Runnable(){

            @Override
            public final void run() {
                AttributionHandler.this.sendAttributionRequest();
            }
        }, ATTRIBUTION_TIMER_NAME);
        this.init(iActivityHandler, bl, iActivityPackageSender);
    }

    private void sendAttributionRequest() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                AttributionHandler.this.sendAttributionRequestI();
            }
        });
    }

    private void getAttributionI(long l) {
        if (this.timer.getFireIn() > l) {
            return;
        }
        if (l != 0L) {
            double d = (double)l / 1000.0;
            String string = Util.SecondsDisplayFormat.format(d);
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            this.logger.debug("Waiting to query attribution in %s seconds", objectArray2);
        }
        this.timer.startIn(l);
    }

    private void checkAttributionI(IActivityHandler iActivityHandler, ResponseData object) {
        if (((ResponseData)object).jsonResponse == null) {
            return;
        }
        object = ((ResponseData)object).askIn;
        if (object != null && (Long)object >= 0L) {
            iActivityHandler.setAskingAttribution(true);
            this.lastInitiatedBy = "backend";
            this.getAttributionI((Long)object);
            return;
        }
        iActivityHandler.setAskingAttribution(false);
    }

    private void checkSessionResponseI(IActivityHandler iActivityHandler, SessionResponseData sessionResponseData) {
        this.checkAttributionI(iActivityHandler, sessionResponseData);
        iActivityHandler.launchSessionResponseTasks(sessionResponseData);
    }

    private void checkSdkClickResponseI(IActivityHandler iActivityHandler, SdkClickResponseData sdkClickResponseData) {
        this.checkAttributionI(iActivityHandler, sdkClickResponseData);
        iActivityHandler.launchSdkClickResponseTasks(sdkClickResponseData);
    }

    private void checkAttributionResponseI(IActivityHandler iActivityHandler, AttributionResponseData attributionResponseData) {
        AttributionHandler attributionHandler = this;
        attributionHandler.checkAttributionI(iActivityHandler, attributionResponseData);
        attributionHandler.checkDeeplinkI(attributionResponseData);
        iActivityHandler.launchAttributionResponseTasks(attributionResponseData);
    }

    private void checkDeeplinkI(AttributionResponseData attributionResponseData) {
        Object object = attributionResponseData.jsonResponse;
        if (object == null) {
            return;
        }
        if ((object = object.optJSONObject("attribution")) == null) {
            return;
        }
        if ((object = object.optString("deeplink", null)) == null) {
            return;
        }
        attributionResponseData.deeplink = Uri.parse((String)object);
    }

    private void sendAttributionRequestI() {
        if (((IActivityHandler)this.activityHandlerWeakRef.get()).getActivityState().isGdprForgotten) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return;
        }
        AttributionHandler attributionHandler = this;
        ActivityPackage activityPackage = attributionHandler.buildAndGetAttributionPackage(((IActivityHandler)attributionHandler.activityHandlerWeakRef.get()).getInternalState());
        String string = activityPackage.getExtendedString();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        attributionHandler.logger.verbose("%s", objectArray2);
        attributionHandler.activityPackageSender.sendActivityPackage(activityPackage, null, this);
    }

    private ActivityPackage buildAndGetAttributionPackage(ActivityHandler.InternalState object) {
        PackageBuilder packageBuilder;
        long l = System.currentTimeMillis();
        Object object2 = (IActivityHandler)this.activityHandlerWeakRef.get();
        Object object3 = packageBuilder;
        PackageBuilder packageBuilder2 = object3;
        ActivityHandler.InternalState internalState = object;
        PackageBuilder packageBuilder3 = object3;
        IActivityHandler iActivityHandler = object2;
        object = iActivityHandler.getAdjustConfig();
        object2 = iActivityHandler.getDeviceInfo();
        object3 = iActivityHandler.getActivityState();
        GlobalParameters globalParameters = iActivityHandler.getGlobalParameters();
        FirstSessionDelayManager firstSessionDelayManager = iActivityHandler.getFirstSessionDelayManager();
        packageBuilder3((AdjustConfig)object, (DeviceInfo)object2, (ActivityState)object3, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = internalState;
        this.lastInitiatedBy = null;
        return packageBuilder.buildAttributionPackage(this.lastInitiatedBy);
    }

    public static /* synthetic */ String access$102(AttributionHandler attributionHandler, String string) {
        attributionHandler.lastInitiatedBy = string;
        return string;
    }

    @Override
    public void teardown() {
        AttributionHandler attributionHandler = this;
        attributionHandler.logger.verbose("AttributionHandler teardown", new Object[0]);
        WeakReference<IActivityHandler> weakReference = attributionHandler.timer;
        if (weakReference != null) {
            ((TimerOnce)((Object)weakReference)).teardown();
        }
        if ((weakReference = this.scheduler) != null) {
            weakReference.teardown();
        }
        if ((weakReference = this.activityHandlerWeakRef) != null) {
            weakReference.clear();
        }
        AttributionHandler attributionHandler2 = this;
        attributionHandler2.timer = null;
        attributionHandler2.logger = null;
        attributionHandler2.scheduler = null;
        attributionHandler2.activityHandlerWeakRef = null;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.paused = bl ^ true;
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void getAttribution() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                2 v0 = this;
                AttributionHandler.access$102(v0.AttributionHandler.this, "sdk");
                v0.AttributionHandler.this.getAttributionI(0L);
            }
        });
    }

    @Override
    public void checkSessionResponse(final SessionResponseData sessionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                IActivityHandler iActivityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (iActivityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSessionResponseI(iActivityHandler, sessionResponseData);
            }
        });
    }

    @Override
    public void checkSdkClickResponse(final SdkClickResponseData sdkClickResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                IActivityHandler iActivityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (iActivityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSdkClickResponseI(iActivityHandler, sdkClickResponseData);
            }
        });
    }

    public void checkAttributionResponse(final AttributionResponseData attributionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                IActivityHandler iActivityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (iActivityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(iActivityHandler, attributionResponseData);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public void onResponseDataCallback(final ResponseData responseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                IActivityHandler iActivityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (iActivityHandler == null) {
                    return;
                }
                ResponseData responseData2 = responseData;
                if (responseData2.trackingState == TrackingState.OPTED_OUT) {
                    iActivityHandler.gotOptOutResponse();
                    return;
                }
                if (!(responseData2 instanceof AttributionResponseData)) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(iActivityHandler, (AttributionResponseData)responseData2);
            }
        });
    }
}

