/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustInstance;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.OnAdidReadListener;
import com.adjust.sdk.OnAttributionChangedListener;
import com.adjust.sdk.OnAttributionReadListener;
import com.adjust.sdk.OnDeeplinkResolvedListener;
import com.adjust.sdk.OnDeferredDeeplinkResponseListener;
import com.adjust.sdk.OnEventTrackingFailedListener;
import com.adjust.sdk.OnEventTrackingSucceededListener;
import com.adjust.sdk.OnSessionTrackingFailedListener;
import com.adjust.sdk.OnSessionTrackingSucceededListener;
import com.adjust.sdk.Util;
import java.util.ArrayList;
import java.util.List;

public class AdjustConfig {
    public static final String ENVIRONMENT_SANDBOX = "sandbox";
    public static final String ENVIRONMENT_PRODUCTION = "production";
    String basePath;
    String gdprPath;
    String subscriptionPath;
    String purchaseVerificationPath;
    Context context;
    String appToken;
    String environment;
    String processName;
    String sdkPrefix;
    String defaultTracker;
    OnAttributionChangedListener onAttributionChangedListener;
    OnEventTrackingSucceededListener onEventTrackingSucceededListener;
    OnEventTrackingFailedListener onEventTrackingFailedListener;
    OnSessionTrackingSucceededListener onSessionTrackingSucceededListener;
    OnSessionTrackingFailedListener onSessionTrackingFailedListener;
    OnDeferredDeeplinkResponseListener onDeferredDeeplinkResponseListener;
    boolean isSendingInBackgroundEnabled;
    AdjustInstance.PreLaunchActions preLaunchActions;
    ILogger logger;
    String pushToken;
    Boolean startEnabled;
    boolean startOffline;
    String externalDeviceId;
    boolean isPreinstallTrackingEnabled;
    Boolean isCostDataInAttributionEnabled;
    List<String> urlStrategyDomains;
    boolean useSubdomains;
    boolean isDataResidency;
    String preinstallFilePath;
    boolean coppaComplianceEnabled;
    boolean playStoreKidsComplianceEnabled;
    String fbAppId;
    boolean isDeviceIdsReadingOnceEnabled;
    OnDeeplinkResolvedListener cachedDeeplinkResolutionCallback;
    ArrayList<OnAdidReadListener> cachedAdidReadCallbacks;
    Integer eventDeduplicationIdsMaxSize;
    ArrayList<OnAttributionReadListener> cachedAttributionReadCallbacks;

    public AdjustConfig(Context context, String string, String string2) {
        ArrayList arrayList;
        ArrayList arrayList2;
        AdjustConfig adjustConfig = object;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        adjustConfig.cachedAdidReadCallbacks = object;
        object = arrayList;
        arrayList = new ArrayList();
        adjustConfig.cachedAttributionReadCallbacks = object;
        adjustConfig.init(context, string, string2, false);
    }

    public AdjustConfig(Context context, String string, String string2, boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2;
        AdjustConfig adjustConfig = object;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        adjustConfig.cachedAdidReadCallbacks = object;
        object = arrayList;
        arrayList = new ArrayList();
        adjustConfig.cachedAttributionReadCallbacks = object;
        adjustConfig.init(context, string, string2, bl);
    }

    private void init(Context context, String string, String string2, boolean bl) {
        this.logger = AdjustFactory.getLogger();
        if (bl && ENVIRONMENT_PRODUCTION.equals(string2)) {
            this.setLogLevel(LogLevel.SUPPRESS, string2);
        } else {
            this.setLogLevel(LogLevel.INFO, string2);
        }
        if (context != null) {
            context = context.getApplicationContext();
        }
        AdjustConfig adjustConfig = this;
        adjustConfig.context = context;
        adjustConfig.appToken = string;
        adjustConfig.environment = string2;
        adjustConfig.isSendingInBackgroundEnabled = false;
        adjustConfig.isPreinstallTrackingEnabled = false;
        adjustConfig.isDeviceIdsReadingOnceEnabled = false;
        adjustConfig.coppaComplianceEnabled = false;
        adjustConfig.playStoreKidsComplianceEnabled = false;
    }

    private void setLogLevel(LogLevel logLevel, String string) {
        this.logger.setLogLevel(logLevel, ENVIRONMENT_PRODUCTION.equals(string));
    }

    private boolean checkContext(Context context) {
        if (context == null) {
            this.logger.error("Missing context", new Object[0]);
            return false;
        }
        if (!Util.checkPermission(context, "android.permission.INTERNET")) {
            this.logger.error("Missing permission: INTERNET", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkAppToken(String string) {
        if (string == null) {
            objectArray2.logger.error("Missing App Token", new Object[0]);
            return false;
        }
        if (string.length() != 12) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray2.logger.error("Malformed App Token '%s'", objectArray2);
            return false;
        }
        return true;
    }

    private boolean checkEnvironment(String string) {
        if (string == null) {
            objectArray2.logger.error("Missing environment", new Object[0]);
            return false;
        }
        if (string.equals(ENVIRONMENT_SANDBOX)) {
            objectArray2.logger.warnInProduction("SANDBOX: Adjust is running in Sandbox mode. Use this setting for testing. Don't forget to set the environment to `production` before publishing!", new Object[0]);
            return true;
        }
        if (string.equals(ENVIRONMENT_PRODUCTION)) {
            objectArray2.logger.warnInProduction("PRODUCTION: Adjust is running in Production mode. Use this setting only for the build that you want to publish. Set the environment to `sandbox` if you want to test your app!", new Object[0]);
            return true;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray2.logger.error("Unknown environment '%s'", objectArray2);
        return false;
    }

    public void setLogLevel(LogLevel logLevel) {
        AdjustConfig adjustConfig = this;
        adjustConfig.setLogLevel(logLevel, adjustConfig.environment);
    }

    public void setSdkPrefix(String string) {
        this.sdkPrefix = string;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public void setDefaultTracker(String string) {
        this.defaultTracker = string;
    }

    public void setExternalDeviceId(String string) {
        this.externalDeviceId = string;
    }

    public void setPreinstallFilePath(String string) {
        this.preinstallFilePath = string;
    }

    public void enableCoppaCompliance() {
        this.coppaComplianceEnabled = true;
    }

    public void enablePlayStoreKidsCompliance() {
        this.playStoreKidsComplianceEnabled = true;
    }

    public void setFbAppId(String string) {
        this.fbAppId = string;
    }

    public void setEventDeduplicationIdsMaxSize(Integer n) {
        this.eventDeduplicationIdsMaxSize = n;
    }

    public void setUrlStrategy(List<String> list, boolean bl, boolean bl2) {
        if (list != null && !list.isEmpty()) {
            AdjustConfig adjustConfig = this;
            adjustConfig.urlStrategyDomains = list;
            adjustConfig.useSubdomains = bl;
            adjustConfig.isDataResidency = bl2;
            return;
        }
        this.logger.error("Invalid URL strategy domains array", new Object[0]);
    }

    public void enablePreinstallTracking() {
        this.isPreinstallTrackingEnabled = true;
    }

    public void enableCostDataInAttribution() {
        this.isCostDataInAttributionEnabled = Boolean.TRUE;
    }

    public void enableSendingInBackground() {
        this.isSendingInBackgroundEnabled = true;
    }

    public void enableDeviceIdsReadingOnce() {
        this.isDeviceIdsReadingOnceEnabled = true;
    }

    public void setOnAttributionChangedListener(OnAttributionChangedListener onAttributionChangedListener) {
        this.onAttributionChangedListener = onAttributionChangedListener;
    }

    public void setOnEventTrackingSucceededListener(OnEventTrackingSucceededListener onEventTrackingSucceededListener) {
        this.onEventTrackingSucceededListener = onEventTrackingSucceededListener;
    }

    public void setOnEventTrackingFailedListener(OnEventTrackingFailedListener onEventTrackingFailedListener) {
        this.onEventTrackingFailedListener = onEventTrackingFailedListener;
    }

    public void setOnSessionTrackingSucceededListener(OnSessionTrackingSucceededListener onSessionTrackingSucceededListener) {
        this.onSessionTrackingSucceededListener = onSessionTrackingSucceededListener;
    }

    public void setOnSessionTrackingFailedListener(OnSessionTrackingFailedListener onSessionTrackingFailedListener) {
        this.onSessionTrackingFailedListener = onSessionTrackingFailedListener;
    }

    public void setOnDeferredDeeplinkResponseListener(OnDeferredDeeplinkResponseListener onDeferredDeeplinkResponseListener) {
        this.onDeferredDeeplinkResponseListener = onDeferredDeeplinkResponseListener;
    }

    public Context getContext() {
        return this.context;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getSdkPrefix() {
        return this.sdkPrefix;
    }

    public String getDefaultTracker() {
        return this.defaultTracker;
    }

    public String getExternalDeviceId() {
        return this.externalDeviceId;
    }

    public boolean isPreinstallTrackingEnabled() {
        return this.isPreinstallTrackingEnabled;
    }

    public Boolean getCostDataInAttributionEnabled() {
        return this.isCostDataInAttributionEnabled;
    }

    public boolean isSendingInBackgroundEnabled() {
        return this.isSendingInBackgroundEnabled;
    }

    public Integer getEventDeduplicationIdsMaxSize() {
        return this.eventDeduplicationIdsMaxSize;
    }

    public List<String> getUrlStrategyDomains() {
        return this.urlStrategyDomains;
    }

    public String getPreinstallFilePath() {
        return this.preinstallFilePath;
    }

    public boolean isCoppaComplianceEnabled() {
        return this.coppaComplianceEnabled;
    }

    public boolean isPlayStoreKidsComplianceEnabled() {
        return this.playStoreKidsComplianceEnabled;
    }

    public String getFbAppId() {
        return this.fbAppId;
    }

    public boolean isDeviceIdsReadingOnceEnabled() {
        return this.isDeviceIdsReadingOnceEnabled;
    }

    public OnAttributionChangedListener getOnAttributionChangedListener() {
        return this.onAttributionChangedListener;
    }

    public OnEventTrackingSucceededListener getOnEventTrackingSucceededListener() {
        return this.onEventTrackingSucceededListener;
    }

    public OnEventTrackingFailedListener getOnEventTrackingFailedListener() {
        return this.onEventTrackingFailedListener;
    }

    public OnSessionTrackingSucceededListener getOnSessionTrackingSucceededListener() {
        return this.onSessionTrackingSucceededListener;
    }

    public OnSessionTrackingFailedListener getOnSessionTrackingFailedListener() {
        return this.onSessionTrackingFailedListener;
    }

    public OnDeferredDeeplinkResponseListener getOnDeeplinkResponseListener() {
        return this.onDeferredDeeplinkResponseListener;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public boolean isValid() {
        AdjustConfig adjustConfig = this;
        if (!adjustConfig.checkAppToken(adjustConfig.appToken)) {
            return false;
        }
        AdjustConfig adjustConfig2 = this;
        if (!adjustConfig2.checkEnvironment(adjustConfig2.environment)) {
            return false;
        }
        AdjustConfig adjustConfig3 = this;
        return adjustConfig3.checkContext(adjustConfig3.context);
    }
}

