/*
 * Decompiled with CFR 0.152.
 */
package co.vendorflow.oss.maildrop.test;

import co.vendorflow.oss.maildrop.api.MailMessage;
import co.vendorflow.oss.maildrop.api.MailStatus;
import co.vendorflow.oss.maildrop.api.MaildropException;
import co.vendorflow.oss.maildrop.api.sink.MailSink;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class InMemoryMailSink
implements MailSink {
    private static final MailStatus RETURN_STATUS = new MailStatus(MailStatus.Lifecycle.PERSISTED, Collections.emptyMap());
    private final AtomicReference<List<MailMessage>> queueReference = new AtomicReference();

    public InMemoryMailSink() {
        this.drainQueue();
    }

    public synchronized MailStatus deliver(MailMessage message) throws MaildropException {
        this.queueReference.get().add(message);
        return RETURN_STATUS;
    }

    public List<MailMessage> getQueue() {
        return this.queueReference.get();
    }

    public synchronized List<MailMessage> drainQueue() {
        return this.queueReference.getAndSet(Collections.synchronizedList(new LinkedList()));
    }
}

